/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.pennchinese.UniversalChineseGrammaticalStructure;
import java.util.function.Predicate;

public class UniversalChineseGrammaticalStructureFactory
implements GrammaticalStructureFactory {
    private final Predicate<String> puncFilter;
    private final HeadFinder hf;

    public UniversalChineseGrammaticalStructureFactory() {
        this(null, null);
    }

    public UniversalChineseGrammaticalStructureFactory(Predicate<String> puncFilter) {
        this(puncFilter, null);
    }

    public UniversalChineseGrammaticalStructureFactory(Predicate<String> puncFilter, HeadFinder hf) {
        this.puncFilter = puncFilter;
        this.hf = hf;
    }

    @Override
    public UniversalChineseGrammaticalStructure newGrammaticalStructure(Tree t) {
        if (this.puncFilter == null && this.hf == null) {
            return new UniversalChineseGrammaticalStructure(t);
        }
        if (this.hf == null) {
            return new UniversalChineseGrammaticalStructure(t, this.puncFilter);
        }
        return new UniversalChineseGrammaticalStructure(t, this.puncFilter, this.hf);
    }
}

