/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;

public class IntTaggedWord
implements Serializable,
Comparable<IntTaggedWord> {
    public static final int ANY_WORD_INT = -1;
    public static final int ANY_TAG_INT = -1;
    public static final int STOP_WORD_INT = -2;
    public static final int STOP_TAG_INT = -2;
    public static final String ANY = ".*.";
    public static final String STOP = "!!!STOP!!!";
    public final int word;
    public final short tag;
    private static final char[] charsToEscape = new char[]{'\"'};
    private static final long serialVersionUID = 1L;

    public int tag() {
        return this.tag;
    }

    public int word() {
        return this.word;
    }

    public String wordString(Index<String> wordIndex) {
        String wordStr = this.word >= 0 ? wordIndex.get(this.word) : (this.word == -1 ? ANY : STOP);
        return wordStr;
    }

    public String tagString(Index<String> tagIndex) {
        String tagStr = this.tag >= 0 ? tagIndex.get(this.tag) : (this.tag == -1 ? ANY : STOP);
        return tagStr;
    }

    public int hashCode() {
        return this.word ^ this.tag << 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IntTaggedWord) {
            IntTaggedWord i = (IntTaggedWord)o;
            return this.word == i.word && this.tag == i.tag;
        }
        return false;
    }

    @Override
    public int compareTo(IntTaggedWord that) {
        if (this.tag != that.tag) {
            return this.tag - that.tag;
        }
        return this.word - that.word;
    }

    public String toLexicalEntry(Index<String> wordIndex, Index<String> tagIndex) {
        String wordStr = this.wordString(wordIndex);
        String tagStr = this.tagString(tagIndex);
        return '\"' + StringUtils.escapeString(tagStr, charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(wordStr, charsToEscape, '\\') + '\"';
    }

    public String toString() {
        return this.word + "/" + this.tag;
    }

    public String toString(Index<String> wordIndex, Index<String> tagIndex) {
        return this.wordString(wordIndex) + '/' + this.tagString(tagIndex);
    }

    public String toString(String arg, Index<String> wordIndex, Index<String> tagIndex) {
        if (arg.equals("verbose")) {
            return this.wordString(wordIndex) + '[' + this.word + "]/" + this.tagString(tagIndex) + '[' + this.tag + ']';
        }
        return this.toString(wordIndex, tagIndex);
    }

    public IntTaggedWord(int word, int tag) {
        this.word = word;
        this.tag = (short)tag;
    }

    public TaggedWord toTaggedWord(Index<String> wordIndex, Index<String> tagIndex) {
        String wordStr = this.wordString(wordIndex);
        String tagStr = this.tagString(tagIndex);
        return new TaggedWord(wordStr, tagStr);
    }

    public IntTaggedWord(String s, char splitChar, Index<String> wordIndex, Index<String> tagIndex) {
        this(IntTaggedWord.extractWord(s, splitChar), IntTaggedWord.extractTag(s, splitChar), wordIndex, tagIndex);
    }

    private static String extractWord(String s, char splitChar) {
        int n = s.lastIndexOf(splitChar);
        String result = s.substring(0, n);
        return result;
    }

    private static String extractTag(String s, char splitChar) {
        int n = s.lastIndexOf(splitChar);
        String result = s.substring(n + 1);
        return result;
    }

    public IntTaggedWord(String wordString, String tagString, Index<String> wordIndex, Index<String> tagIndex) {
        switch (wordString) {
            case ".*.": {
                this.word = -1;
                break;
            }
            case "!!!STOP!!!": {
                this.word = -2;
                break;
            }
            default: {
                this.word = wordIndex.addToIndex(wordString);
            }
        }
        switch (tagString) {
            case ".*.": {
                this.tag = (short)-1;
                break;
            }
            case "!!!STOP!!!": {
                this.tag = (short)-2;
                break;
            }
            default: {
                this.tag = (short)tagIndex.addToIndex(tagString);
            }
        }
    }
}

