/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class JavadocTypeCheck
extends Check {
    private Scope mScope = Scope.PRIVATE;
    private Scope mExcludeScope;
    private Pattern mAuthorFormatPattern;
    private Pattern mVersionFormatPattern;
    private String mAuthorFormat;
    private String mVersionFormat;
    private boolean mAllowMissingParamTags;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setExcludeScope(String aScope) {
        this.mExcludeScope = Scope.getInstance(aScope);
    }

    public void setAuthorFormat(String aFormat) throws ConversionException {
        try {
            this.mAuthorFormat = aFormat;
            this.mAuthorFormatPattern = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
    }

    public void setVersionFormat(String aFormat) throws ConversionException {
        try {
            this.mVersionFormat = aFormat;
            this.mVersionFormatPattern = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
    }

    public void setAllowMissingParamTags(boolean aFlag) {
        this.mAllowMissingParamTags = aFlag;
    }

    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157};
    }

    public void visitToken(DetailAST aAST) {
        if (this.shouldCheck(aAST)) {
            int lineNo;
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(lineNo = aAST.getLineNo());
            if (cmt == null) {
                this.log(lineNo, "javadoc.missing");
            } else if (ScopeUtils.isOuterMostType(aAST)) {
                Vector tags = this.getJavadocTags(cmt);
                this.checkTag(lineNo, tags, "author", this.mAuthorFormatPattern, this.mAuthorFormat);
                this.checkTag(lineNo, tags, "version", this.mVersionFormatPattern, this.mVersionFormat);
                List typeParamNames = CheckUtils.getTypeParameterNames(aAST);
                if (!this.mAllowMissingParamTags) {
                    Iterator typeParamNameIt = typeParamNames.iterator();
                    while (typeParamNameIt.hasNext()) {
                        this.checkTypeParamTag(lineNo, tags, (String)typeParamNameIt.next());
                    }
                }
                this.checkUnusedTypeParamTags(tags, typeParamNames);
            }
        }
    }

    private boolean shouldCheck(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        Scope scope = ScopeUtils.inInterfaceOrAnnotationBlock(aAST) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope(aAST);
        return scope.isIn(this.mScope) && (surroundingScope == null || surroundingScope.isIn(this.mScope)) && (this.mExcludeScope == null || !scope.isIn(this.mExcludeScope) || surroundingScope != null && !surroundingScope.isIn(this.mExcludeScope));
    }

    private Vector getJavadocTags(TextBlock aCmt) {
        String[] text = aCmt.getText();
        Vector<JavadocTag> tags = new Vector<JavadocTag>();
        Pattern tagPattern = Utils.getPattern("/\\*{2,}\\s*@(\\p{Alpha}+)\\s");
        for (int i = 0; i < text.length; ++i) {
            String s = text[i];
            Matcher tagMatcher = tagPattern.matcher(s);
            if (tagMatcher.find()) {
                String tagName = tagMatcher.group(1);
                String content = s.substring(tagMatcher.end(1));
                if (content.endsWith("*/")) {
                    content = content.substring(0, content.length() - 2);
                }
                int col = tagMatcher.start(1) - 1;
                if (i == 0) {
                    col += aCmt.getStartColNo();
                }
                tags.add(new JavadocTag(aCmt.getStartLineNo() + i, col, tagName, content.trim()));
            }
            tagPattern = Utils.getPattern("^\\s*\\**\\s*@(\\p{Alpha}+)\\s");
        }
        return tags;
    }

    private void checkTag(int aLineNo, Vector aTags, String aTag, Pattern aFormatPattern, String aFormat) {
        if (aFormatPattern == null) {
            return;
        }
        int tagCount = 0;
        for (int i = aTags.size() - 1; i >= 0; --i) {
            JavadocTag tag = (JavadocTag)aTags.get(i);
            if (!tag.getTag().equals(aTag)) continue;
            ++tagCount;
            if (aFormatPattern.matcher(tag.getArg1()).find()) continue;
            this.log(aLineNo, "type.tagFormat", (Object)("@" + aTag), (Object)aFormat);
        }
        if (tagCount == 0) {
            this.log(aLineNo, "type.missingTag", (Object)("@" + aTag));
        }
    }

    private void checkTypeParamTag(int aLineNo, Vector aTags, String aTypeParamName) {
        boolean found = false;
        for (int i = aTags.size() - 1; i >= 0; --i) {
            JavadocTag tag = (JavadocTag)aTags.get(i);
            if (!tag.getTag().equals("param") || tag.getArg1() == null || tag.getArg1().indexOf("<" + aTypeParamName + ">") != 0) continue;
            found = true;
        }
        if (!found) {
            this.log(aLineNo, "type.missingTag", (Object)("@param <" + aTypeParamName + ">"));
        }
    }

    private void checkUnusedTypeParamTags(Vector aTags, List aTypeParamNames) {
        Pattern pattern = Utils.getPattern("\\s*<([^>]+)>.*");
        for (int i = aTags.size() - 1; i >= 0; --i) {
            JavadocTag tag = (JavadocTag)aTags.get(i);
            if (!tag.getTag().equals("param")) continue;
            if (tag.getArg1() != null) {
                Matcher matcher = pattern.matcher(tag.getArg1());
                String typeParamName = null;
                if (matcher.matches()) {
                    typeParamName = matcher.group(1).trim();
                    if (aTypeParamNames.contains(typeParamName)) continue;
                    this.log(tag.getLineNo(), tag.getColumnNo(), "javadoc.unusedTag", "@param", "<" + typeParamName + ">");
                    continue;
                }
                this.log(tag.getLineNo(), tag.getColumnNo(), "javadoc.unusedTagGeneral");
                continue;
            }
            this.log(tag.getLineNo(), tag.getColumnNo(), "javadoc.unusedTagGeneral");
        }
    }
}

