/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.Artifact;
import org.javacs.kt.classpath.ClassPathEntry;
import org.javacs.kt.classpath.ClassPathResolver;
import org.javacs.kt.classpath.MavenClassPathResolverKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/javacs/kt/classpath/MavenClassPathResolver;", "Lorg/javacs/kt/classpath/ClassPathResolver;", "pom", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "artifacts", "", "Lorg/javacs/kt/classpath/Artifact;", "classpath", "Lorg/javacs/kt/classpath/ClassPathEntry;", "getClasspath", "()Ljava/util/Set;", "classpathWithSources", "getClasspathWithSources", "currentBuildFileVersion", "", "getCurrentBuildFileVersion", "()J", "resolverType", "", "getResolverType", "()Ljava/lang/String;", "Companion", "shared"})
@SourceDebugExtension(value={"SMAP\nMavenClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenClassPathResolver.kt\norg/javacs/kt/classpath/MavenClassPathResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1603#2,9:215\n1855#2:224\n1856#2:227\n1612#2:228\n1603#2,9:229\n1855#2:238\n1856#2:240\n1612#2:241\n1#3:225\n1#3:226\n1#3:239\n*S KotlinDebug\n*F\n+ 1 MavenClassPathResolver.kt\norg/javacs/kt/classpath/MavenClassPathResolver\n*L\n30#1:215,9\n30#1:224\n30#1:227\n30#1:228\n50#1:229,9\n50#1:238\n50#1:240\n50#1:241\n30#1:226\n50#1:239\n*E\n"})
public final class MavenClassPathResolver
implements ClassPathResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path pom;
    @Nullable
    private Set<Artifact> artifacts;
    @NotNull
    private final String resolverType;

    private MavenClassPathResolver(Path pom) {
        this.pom = pom;
        this.resolverType = "Maven";
    }

    @Override
    @NotNull
    public String getResolverType() {
        return this.resolverType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspath() {
        void $this$mapNotNullTo$iv$iv;
        Object[] objectArray;
        Path dependenciesOutput = MavenClassPathResolverKt.access$generateMavenDependencyList(this.pom);
        Set artifacts2 = MavenClassPathResolverKt.access$readMavenDependencyList(dependenciesOutput);
        if (artifacts2.isEmpty()) {
            objectArray = new Object[]{this.pom};
            LoggerKt.getLOG().warn("No artifacts found in {}", objectArray);
        } else if (artifacts2.size() < 5) {
            objectArray = new Object[]{artifacts2, this.pom};
            LoggerKt.getLOG().info("Found {} in {}", objectArray);
        } else {
            objectArray = new Object[]{artifacts2.size(), this.pom};
            LoggerKt.getLOG().info("Found {} artifacts in {}", objectArray);
        }
        Files.deleteIfExists(dependenciesOutput);
        this.artifacts = artifacts2;
        Iterable $this$mapNotNull$iv = artifacts2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ClassPathEntry classPathEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Artifact it = (Artifact)element$iv$iv;
            boolean bl2 = false;
            if (MavenClassPathResolverKt.access$findMavenArtifact(it, false) != null) {
                Path it1;
                boolean bl3 = false;
                classPathEntry = new ClassPathEntry(it1, null);
            } else {
                classPathEntry = null;
            }
            if (classPathEntry == null) continue;
            ClassPathEntry it$iv$iv = classPathEntry;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathWithSources() {
        void $this$mapNotNullTo$iv$iv;
        Set artifacts2 = null;
        if (this.artifacts != null) {
            Set set = this.artifacts;
            Intrinsics.checkNotNull(set);
            artifacts2 = set;
        } else {
            Path dependenciesOutput = MavenClassPathResolverKt.access$generateMavenDependencyList(this.pom);
            artifacts2 = MavenClassPathResolverKt.access$readMavenDependencyList(dependenciesOutput);
            Files.deleteIfExists(dependenciesOutput);
        }
        Path sourcesOutput = MavenClassPathResolverKt.access$generateMavenDependencySourcesList(this.pom);
        artifacts2 = MavenClassPathResolverKt.access$readMavenDependencyListWithSources(artifacts2, sourcesOutput);
        Files.deleteIfExists(sourcesOutput);
        Iterable $this$mapNotNull$iv = artifacts2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ClassPathEntry classPathEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Artifact it = (Artifact)element$iv$iv;
            boolean bl2 = false;
            if (MavenClassPathResolverKt.access$findMavenArtifact(it, false) != null) {
                Path it1;
                boolean bl3 = false;
                classPathEntry = new ClassPathEntry(it1, it.getSource() ? MavenClassPathResolverKt.access$findMavenArtifact(it, it.getSource()) : null);
            } else {
                classPathEntry = null;
            }
            if (classPathEntry == null) continue;
            ClassPathEntry it$iv$iv = classPathEntry;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    public long getCurrentBuildFileVersion() {
        return this.pom.toFile().lastModified();
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getClasspathOrEmpty(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspath() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspath(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspathOrEmpty(this);
    }

    public /* synthetic */ MavenClassPathResolver(Path pom, DefaultConstructorMarker $constructor_marker) {
        this(pom);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/javacs/kt/classpath/MavenClassPathResolver$Companion;", "", "()V", "maybeCreate", "Lorg/javacs/kt/classpath/MavenClassPathResolver;", "file", "Ljava/nio/file/Path;", "shared"})
    @SourceDebugExtension(value={"SMAP\nMavenClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenClassPathResolver.kt\norg/javacs/kt/classpath/MavenClassPathResolver$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1#2:215\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MavenClassPathResolver maybeCreate(@NotNull Path file) {
            MavenClassPathResolver mavenClassPathResolver;
            Path path;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Path it = path = file;
            boolean bl = false;
            Path path2 = it.endsWith("pom.xml") ? path : null;
            if (path2 != null) {
                it = path2;
                boolean bl2 = false;
                mavenClassPathResolver = new MavenClassPathResolver(it, null);
            } else {
                mavenClassPathResolver = null;
            }
            return mavenClassPathResolver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

