/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u0007\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0007\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\f*\u00020\u0002\u00a8\u0006\u0010"}, d2={"getJsFunAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "getJsPrimitiveType", "getWasmArrayAnnotation", "Lorg/jetbrains/kotlin/backend/wasm/utils/WasmArrayInfo;", "getWasmExportNameIfWasmExport", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getWasmImportDescriptor", "Lorg/jetbrains/kotlin/wasm/ir/WasmImportDescriptor;", "getWasmOpAnnotation", "hasExcludedFromCodegenAnnotation", "", "hasWasmAutoboxedAnnotation", "hasWasmNoOpCastAnnotation", "hasWasmPrimitiveConstructorAnnotation", "backend.wasm"})
public final class AnnotationsKt {
    public static final boolean hasExcludedFromCodegenAnnotation(@NotNull IrAnnotationContainer $this$hasExcludedFromCodegenAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasExcludedFromCodegenAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$hasExcludedFromCodegenAnnotation, new FqName("kotlin.wasm.internal.ExcludedFromCodegen"));
    }

    @Nullable
    public static final WasmImportDescriptor getWasmImportDescriptor(@NotNull IrFunction $this$getWasmImportDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$getWasmImportDescriptor, (String)"<this>");
        IrConstructorCall irConstructorCall2 = IrUtilsKt.getAnnotation($this$getWasmImportDescriptor, new FqName("kotlin.wasm.WasmImport"));
        if (irConstructorCall2 == null) {
            return null;
        }
        IrConstructorCall annotation2 = irConstructorCall2;
        IrExpression irExpression = annotation2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<kotlin.String>");
        String string2 = (String)((IrConst)irExpression).getValue();
        IrExpression irExpression2 = annotation2.getValueArgument(1);
        Object object = irExpression2 instanceof IrConst ? (IrConst)irExpression2 : null;
        if (object == null || (object = (String)((IrConst)object).getValue()) == null) {
            String string3 = $this$getWasmImportDescriptor.getName().asString();
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        }
        return new WasmImportDescriptor(string2, (String)object);
    }

    @Nullable
    public static final String getWasmOpAnnotation(@NotNull IrAnnotationContainer $this$getWasmOpAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$getWasmOpAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall2 = IrUtilsKt.getAnnotation($this$getWasmOpAnnotation, new FqName("kotlin.wasm.internal.WasmOp"));
        return irConstructorCall2 != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall2) : null;
    }

    public static final boolean hasWasmNoOpCastAnnotation(@NotNull IrAnnotationContainer $this$hasWasmNoOpCastAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWasmNoOpCastAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmNoOpCastAnnotation, new FqName("kotlin.wasm.internal.WasmNoOpCast"));
    }

    public static final boolean hasWasmAutoboxedAnnotation(@NotNull IrAnnotationContainer $this$hasWasmAutoboxedAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWasmAutoboxedAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmAutoboxedAnnotation, new FqName("kotlin.wasm.internal.WasmAutoboxed"));
    }

    public static final boolean hasWasmPrimitiveConstructorAnnotation(@NotNull IrAnnotationContainer $this$hasWasmPrimitiveConstructorAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWasmPrimitiveConstructorAnnotation, (String)"<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmPrimitiveConstructorAnnotation, new FqName("kotlin.wasm.internal.WasmPrimitiveConstructor"));
    }

    @Nullable
    public static final WasmArrayInfo getWasmArrayAnnotation(@NotNull IrAnnotationContainer $this$getWasmArrayAnnotation) {
        WasmArrayInfo wasmArrayInfo;
        Intrinsics.checkNotNullParameter((Object)$this$getWasmArrayAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall2 = IrUtilsKt.getAnnotation($this$getWasmArrayAnnotation, new FqName("kotlin.wasm.internal.WasmArrayOf"));
        if (irConstructorCall2 != null) {
            IrConstructorCall it = irConstructorCall2;
            boolean bl = false;
            IrExpression irExpression = it.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrClassReference");
            IrSymbolOwner irSymbolOwner = ((IrClassReference)irExpression).getSymbol().getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            IrClass irClass2 = (IrClass)irSymbolOwner;
            IrExpression irExpression2 = it.getValueArgument(1);
            Intrinsics.checkNotNull((Object)irExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
            Object t = ((IrConst)irExpression2).getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Boolean");
            wasmArrayInfo = new WasmArrayInfo(irClass2, (Boolean)t);
        } else {
            wasmArrayInfo = null;
        }
        return wasmArrayInfo;
    }

    @Nullable
    public static final String getJsFunAnnotation(@NotNull IrAnnotationContainer $this$getJsFunAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsFunAnnotation, (String)"<this>");
        IrConstructorCall irConstructorCall2 = IrUtilsKt.getAnnotation($this$getJsFunAnnotation, new FqName("kotlin.JsFun"));
        return irConstructorCall2 != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall2) : null;
    }

    @Nullable
    public static final String getJsPrimitiveType(@NotNull IrAnnotationContainer $this$getJsPrimitiveType) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsPrimitiveType, (String)"<this>");
        IrConstructorCall irConstructorCall2 = IrUtilsKt.getAnnotation($this$getJsPrimitiveType, new FqName("kotlin.wasm.internal.JsPrimitive"));
        return irConstructorCall2 != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall2) : null;
    }

    @Nullable
    public static final String getWasmExportNameIfWasmExport(@NotNull IrFunction $this$getWasmExportNameIfWasmExport) {
        Intrinsics.checkNotNullParameter((Object)$this$getWasmExportNameIfWasmExport, (String)"<this>");
        IrConstructorCall irConstructorCall2 = IrUtilsKt.getAnnotation($this$getWasmExportNameIfWasmExport, new FqName("kotlin.wasm.WasmExport"));
        if (irConstructorCall2 == null) {
            return null;
        }
        IrConstructorCall annotation2 = irConstructorCall2;
        if (annotation2.getValueArgumentsCount() == 0) {
            return $this$getWasmExportNameIfWasmExport.getName().getIdentifier();
        }
        IrExpression irExpression = annotation2.getValueArgument(0);
        Object object = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        if (object == null || (object = (String)((IrConst)object).getValue()) == null) {
            object = $this$getWasmExportNameIfWasmExport.getName().getIdentifier();
        }
        return object;
    }
}

