/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.CorruptionException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentMapWal;
import com.intellij.util.io.PersistentMapWalPlayer;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.io.WalEvent;
import com.intellij.util.io.WalRecord;
import com.intellij.util.io.WriteAheadLogKt;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a)\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a]\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u0013\"\u0004\b\u0002\u0010\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00172\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u001a0!H\u0002\u00a2\u0006\u0002\u0010\"\u001aB\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u00130$\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017\u001a(\u0010%\u001a\b\u0012\u0004\u0012\u0002H'0&\"\u0004\b\u0000\u0010'2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0\u001f\u001a0\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*\"\u0004\b\u0000\u0010'2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0\u001f\u001aJ\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u00130-\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017\u001a:\u0010.\u001a\u0004\u0018\u00010\u001d\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0002\u001a)\u0010/\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u00132\u0006\u00100\u001a\u0002H\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0002\u00a2\u0006\u0002\u00101\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\"\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"VERSION", "", "checksumGen", "Lkotlin/Function0;", "Ljava/util/zip/CRC32;", "debugWalRecords", "", "getDebugWalRecords", "()Z", "setDebugWalRecords", "(Z)V", "integerExternalizer", "Lcom/intellij/util/io/EnumeratorIntegerDescriptor;", "getIntegerExternalizer", "()Lcom/intellij/util/io/EnumeratorIntegerDescriptor;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "readData", "V", "array", "", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "([BLcom/intellij/util/io/DataExternalizer;)Ljava/lang/Object;", "restoreFromWal", "R", "K", "walFile", "Ljava/nio/file/Path;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "accumulator", "Lcom/intellij/util/io/Accumulator;", "(Ljava/nio/file/Path;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;Lcom/intellij/util/io/Accumulator;)Ljava/lang/Object;", "restoreHashMapFromWal", "", "restoreMemoryEnumeratorFromWal", "", "Data", "dataDescriptor", "restorePersistentEnumeratorFromWal", "Lcom/intellij/util/io/PersistentEnumerator;", "outputMapFile", "restorePersistentMapFromWal", "Lcom/intellij/util/io/PersistentMap;", "tryCompact", "writeData", "value", "(Ljava/lang/Object;Lcom/intellij/util/io/DataExternalizer;)[B", "intellij.platform.util"})
public final class WriteAheadLogKt {
    private static final Function0<CRC32> checksumGen = checksumGen.1.INSTANCE;
    private static volatile boolean debugWalRecords;
    private static final Logger log;

    public static final boolean getDebugWalRecords() {
        return debugWalRecords;
    }

    private static final EnumeratorIntegerDescriptor getIntegerExternalizer() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorIntegerDescriptor, (String)"EnumeratorIntegerDescriptor.INSTANCE");
        return enumeratorIntegerDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final <K, V> Path tryCompact(Path walFile, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer) {
        boolean bl;
        int n;
        IntLinkedOpenHashSet intLinkedOpenHashSet;
        if (!Files.exists(walFile, new LinkOption[0])) {
            return null;
        }
        Object2ObjectOpenCustomHashMap keyToLastEvent2 = new Object2ObjectOpenCustomHashMap(new Hash.Strategy<K>(keyDescriptor){
            final /* synthetic */ KeyDescriptor $keyDescriptor;

            public boolean equals(@Nullable K a, @Nullable K b) {
                if (Intrinsics.areEqual(a, b)) {
                    return true;
                }
                if (a == null) {
                    return false;
                }
                if (b == null) {
                    return false;
                }
                return this.$keyDescriptor.isEqual(a, b);
            }

            public int hashCode(@Nullable K o) {
                return this.$keyDescriptor.getHashCode(o);
            }
            {
                this.$keyDescriptor = $captured_local_variable$0;
            }
        });
        Closeable closeable = new PersistentMapWalPlayer<K, V>(keyDescriptor, valueExternalizer, walFile);
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            PersistentMapWalPlayer it = (PersistentMapWalPlayer)closeable;
            boolean bl4 = false;
            int eventCount = 0;
            for (WalEvent walEvent : it.readWal()) {
                WalEvent walEvent2 = walEvent;
                if (walEvent2 instanceof WalEvent.AppendEvent) {
                    ((IntSet)keyToLastEvent2.computeIfAbsent(walEvent.getKey(), tryCompact.shouldCompact.1.1.INSTANCE)).add(eventCount);
                } else if (walEvent2 instanceof WalEvent.PutEvent) {
                    void set;
                    intLinkedOpenHashSet = new IntLinkedOpenHashSet();
                    boolean bl5 = false;
                    boolean bl6 = false;
                    IntLinkedOpenHashSet intLinkedOpenHashSet2 = intLinkedOpenHashSet;
                    Object k = walEvent.getKey();
                    Object2ObjectOpenCustomHashMap object2ObjectOpenCustomHashMap = keyToLastEvent2;
                    boolean bl7 = false;
                    set.add(eventCount);
                    Unit unit2 = Unit.INSTANCE;
                    object2ObjectOpenCustomHashMap.put(k, intLinkedOpenHashSet);
                } else if (walEvent2 instanceof WalEvent.RemoveEvent) {
                    keyToLastEvent2.put(walEvent.getKey(), new IntLinkedOpenHashSet());
                } else if (walEvent2 instanceof WalEvent.CorruptionEvent) {
                    throw (Throwable)new CorruptionException("wal has been corrupted");
                }
                ((IntSet)keyToLastEvent2.computeIfAbsent(walEvent.getKey(), tryCompact.shouldCompact.1.3.INSTANCE)).add(eventCount);
                n = eventCount;
                eventCount = n + 1;
            }
            bl = keyToLastEvent2.size() * 2 < eventCount;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        boolean shouldCompact2 = bl;
        if (!shouldCompact2) {
            return null;
        }
        Path compactedWalFile = walFile.resolveSibling(walFile.getFileName() + "_compacted");
        Closeable closeable2 = new PersistentMapWalPlayer<K, V>(keyDescriptor, valueExternalizer, walFile);
        boolean bl8 = false;
        bl = false;
        Throwable throwable3 = null;
        try {
            PersistentMapWalPlayer walPlayer = (PersistentMapWalPlayer)closeable2;
            boolean bl9 = false;
            boolean bl10 = walPlayer.getUseCompression$intellij_platform_util();
            Path path = compactedWalFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"compactedWalFile");
            ExecutorService executorService = ConcurrencyUtil.newSameThreadExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"ConcurrencyUtil.newSameThreadExecutorService()");
            Closeable closeable3 = new PersistentMapWal(keyDescriptor, valueExternalizer, bl10, path, executorService, false, 32, null);
            boolean bl11 = false;
            n = 0;
            Throwable throwable4 = null;
            try {
                PersistentMapWal compactedWal = (PersistentMapWal)closeable3;
                boolean bl12 = false;
                Sequence $this$forEachIndexed$iv = walPlayer.readWal();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    IntSet events;
                    void walEvent;
                    int n2 = index$iv++;
                    boolean bl13 = false;
                    if (n2 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    WalEvent walEvent3 = (WalEvent)item$iv;
                    int index2 = n2;
                    boolean bl14 = false;
                    Object key = walEvent.getKey();
                    if ((IntSet)keyToLastEvent2.get(key) == null) {
                        throw (Throwable)new IOException("No events found for key =  " + key);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)events, (String)"keyToLastEvent.get(key) \u2026s found for key =  $key\")");
                    if (!events.contains(index2)) continue;
                    void var28_48 = walEvent;
                    if (var28_48 instanceof WalEvent.AppendEvent) {
                        compactedWal.appendData(key, new AppendablePersistentMap.ValueDataAppender((WalEvent)walEvent){
                            final /* synthetic */ WalEvent $walEvent;

                            public final void append(@NotNull DataOutput out) {
                                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                                out.write(((WalEvent.AppendEvent)this.$walEvent).getData());
                            }
                            {
                                this.$walEvent = walEvent;
                            }
                        });
                        continue;
                    }
                    if (var28_48 instanceof WalEvent.PutEvent) {
                        compactedWal.put(key, ((WalEvent.PutEvent)walEvent).getValue());
                        continue;
                    }
                    if (var28_48 instanceof WalEvent.RemoveEvent || !(var28_48 instanceof WalEvent.CorruptionEvent)) continue;
                    throw (Throwable)new CorruptionException("wal has been corrupted");
                }
                intLinkedOpenHashSet = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable4 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable4);
            }
            Unit unit3 = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable3 = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
        }
        return compactedWalFile;
    }

    private static final <V> V readData(byte[] array2, DataExternalizer<V> valueExternalizer) {
        return valueExternalizer.read(new DataInputStream(new ByteArrayInputStream(array2)));
    }

    private static final <V> byte[] writeData(V value2, DataExternalizer<V> valueExternalizer) {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        valueExternalizer.save(new DataOutputStream(baos), value2);
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WalRecord.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
    }

    public static final /* synthetic */ EnumeratorIntegerDescriptor access$getIntegerExternalizer$p() {
        return WriteAheadLogKt.getIntegerExternalizer();
    }

    public static final /* synthetic */ byte[] access$writeData(Object value2, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.writeData(value2, valueExternalizer);
    }

    public static final /* synthetic */ Path access$tryCompact(Path walFile, KeyDescriptor keyDescriptor, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.tryCompact(walFile, keyDescriptor, valueExternalizer);
    }

    public static final /* synthetic */ Function0 access$getChecksumGen$p() {
        return checksumGen;
    }

    public static final /* synthetic */ Object access$readData(byte[] array2, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.readData(array2, valueExternalizer);
    }
}

