/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt;

import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.SourceExclusions;
import org.javacs.kt.SourceFilesKt;
import org.javacs.kt.util.URIsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a \u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0002\u001a \u0010\n\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"findSourceFiles", "", "Ljava/net/URI;", "root", "Ljava/nio/file/Path;", "logAdded", "", "sources", "", "rootPath", "logRemoved", "patch", "", "sourceText", "change", "Lorg/eclipse/lsp4j/TextDocumentContentChangeEvent;", "server"})
public final class SourceFilesKt {
    private static final String patch(String sourceText, TextDocumentContentChangeEvent change) {
        Range range = change.getRange();
        BufferedReader reader = new BufferedReader(new StringReader(sourceText));
        StringWriter writer = new StringWriter();
        for (int line = 0; line < range.getStart().getLine(); ++line) {
            writer.write(reader.readLine() + "\n");
        }
        int n = range.getStart().getCharacter();
        for (int character = 0; character < n; ++character) {
            writer.write(reader.read());
        }
        writer.write(change.getText());
        n = range.getEnd().getLine() - range.getStart().getLine();
        for (int i = 0; i < n; ++i) {
            reader.readLine();
        }
        if (range.getStart().getLine() == range.getEnd().getLine()) {
            reader.skip(range.getEnd().getCharacter() - range.getStart().getCharacter());
        } else {
            reader.skip(range.getEnd().getCharacter());
        }
        while (true) {
            int next;
            if ((next = reader.read()) == -1) {
                String string = writer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            writer.write(next);
        }
    }

    private static final Set<URI> findSourceFiles(Path root) {
        PathMatcher sourceMatcher = FileSystems.getDefault().getPathMatcher("glob:*.{kt,kts}");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)new SourceExclusions(root).walkIncluded(), (Function1)((Function1)new Function1<Path, Boolean>(sourceMatcher){
            final /* synthetic */ PathMatcher $sourceMatcher;
            {
                this.$sourceMatcher = $sourceMatcher;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$sourceMatcher.matches(it.getFileName());
            }
        })), (Function1)findSourceFiles.2.INSTANCE));
    }

    private static final void logAdded(Collection<URI> sources, Path rootPath) {
        Object[] objectArray = new Object[]{URIsKt.describeURIs(sources), rootPath};
        LoggerKt.getLOG().info("Adding {} under {} to source path", objectArray);
    }

    private static final void logRemoved(Collection<URI> sources, Path rootPath) {
        Object[] objectArray = new Object[]{URIsKt.describeURIs(sources), rootPath};
        LoggerKt.getLOG().info("Removing {} under {} to source path", objectArray);
    }

    public static final /* synthetic */ String access$patch(String sourceText, TextDocumentContentChangeEvent change) {
        return SourceFilesKt.patch(sourceText, change);
    }

    public static final /* synthetic */ Set access$findSourceFiles(Path root) {
        return SourceFilesKt.findSourceFiles(root);
    }

    public static final /* synthetic */ void access$logAdded(Collection sources, Path rootPath) {
        SourceFilesKt.logAdded(sources, rootPath);
    }

    public static final /* synthetic */ void access$logRemoved(Collection sources, Path rootPath) {
        SourceFilesKt.logRemoved(sources, rootPath);
    }
}

