/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Map;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamContext;
import one.util.streamex.StreamEx;

public class EntryStream<K, V>
extends AbstractStreamEx<Map.Entry<K, V>, EntryStream<K, V>> {
    EntryStream(Stream<? extends Map.Entry<K, V>> stream, StreamContext context) {
        super(stream, context);
    }

    EntryStream(Spliterator<? extends Map.Entry<K, V>> spliterator, StreamContext context) {
        super(spliterator, context);
    }

    @Override
    EntryStream<K, V> supply(Stream<Map.Entry<K, V>> stream) {
        return new EntryStream<K, V>(stream, this.context);
    }

    public EntryStream<K, V> filterValues(Predicate<? super V> valuePredicate) {
        return (EntryStream)this.filter((T e) -> valuePredicate.test((Object)e.getValue()));
    }

    public StreamEx<K> keys() {
        return this.map(Map.Entry::getKey);
    }

    public static <K, V> EntryStream<K, V> of(Stream<? extends Map.Entry<K, V>> stream) {
        if (stream instanceof AbstractStreamEx) {
            AbstractStreamEx ase = (AbstractStreamEx)stream;
            if (ase.spliterator != null) {
                return new EntryStream<K, V>(ase.spliterator(), ase.context);
            }
            return new EntryStream<K, V>((Stream)ase.stream(), ase.context);
        }
        return new EntryStream<K, V>(stream, StreamContext.of(stream));
    }

    public static <K, V> EntryStream<K, V> of(Map<K, V> map) {
        return EntryStream.of(map.entrySet().stream());
    }
}

