/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;

public class SwitchHelper {
    public static void simplify(SwitchStatement switchStatement) {
        SwitchExprent switchExprent = (SwitchExprent)switchStatement.getHeadexprent();
        Exprent value = switchExprent.getValue();
        if (SwitchHelper.isEnumArray(value)) {
            MethodWrapper wrapper;
            List<List<Exprent>> caseValues = switchStatement.getCaseValues();
            final HashMap mapping = new HashMap(caseValues.size());
            ArrayExprent array = (ArrayExprent)value;
            ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(((FieldExprent)array.getArray()).getClassname());
            if (classNode != null && (wrapper = classNode.getWrapper().getMethodWrapper("<clinit>", "()V")) != null) {
                wrapper.getOrBuildGraph().iterateExprents(new DirectGraph.ExprentIterator(){

                    @Override
                    public int processExprent(Exprent exprent) {
                        AssignmentExprent assignment;
                        Exprent left;
                        if (exprent instanceof AssignmentExprent && SwitchHelper.isEnumArray(left = (assignment = (AssignmentExprent)exprent).getLeft())) {
                            mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                        }
                        return 0;
                    }
                });
            }
            ArrayList realCaseValues = new ArrayList(caseValues.size());
            for (List<Exprent> caseValue : caseValues) {
                ArrayList<Exprent> values = new ArrayList<Exprent>(caseValue.size());
                realCaseValues.add(values);
                for (Exprent exprent : caseValue) {
                    if (exprent == null) {
                        values.add(null);
                        continue;
                    }
                    Exprent realConst = (Exprent)mapping.get(exprent);
                    if (realConst == null) {
                        DecompilerContext.getLogger().writeMessage("Unable to simplify switch on enum: " + exprent + " not found, available: " + mapping, IFernflowerLogger.Severity.ERROR);
                        return;
                    }
                    values.add(realConst.copy());
                }
            }
            caseValues.clear();
            caseValues.addAll(realCaseValues);
            switchExprent.replaceExprent(value, ((InvocationExprent)array.getIndex()).getInstance().copy());
        }
    }

    private static boolean isEnumArray(Exprent exprent) {
        if (exprent instanceof ArrayExprent) {
            Exprent field = ((ArrayExprent)exprent).getArray();
            return field instanceof FieldExprent && ((FieldExprent)field).getName().startsWith("$SwitchMap");
        }
        return false;
    }
}

