/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.javacs.kt.LoggerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a(\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a7\u0010\u000b\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u00022\"\u0010\f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u000e0\r\"\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u001a'\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0011\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a!\u0010\u0014\u001a\u0002H\u0002\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a#\u0010\u0017\u001a\u0002H\u0002\"\u0004\b\u0000\u0010\u00022\b\u0010\u0018\u001a\u0004\u0018\u0001H\u00022\u0006\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001a\u001a\u001b\u0010\u001b\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001c\u001a1\u0010\u001d\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u001e\u001a\u00020\u00042\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u000eH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u001a\u000e\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0004\u001a\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020$0\u000eH\u0086\b\u00f8\u0001\u0000\u001aT\u0010(\u001a\u0002H)\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010)*\b\u0012\u0004\u0012\u0002H\u00020**\u0002H)2'\u0010+\u001a#\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(0\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020$0,H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101\u001a\u001e\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n*\u00020\u00042\u0006\u00103\u001a\u00020\u0004\u001a\u0012\u00104\u001a\u00020\b*\u00020\b2\u0006\u00105\u001a\u00020\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00066"}, d2={"emptyResult", "", "T", "message", "", "execAndReadStdout", "shellCommand", "directory", "Ljava/nio/file/Path;", "execAndReadStdoutAndStderr", "Lkotlin/Pair;", "firstNonNull", "optionals", "", "Lkotlin/Function0;", "([Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "noFuture", "Ljava/util/concurrent/CompletableFuture;", "contents", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;", "noResult", "result", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "nonNull", "item", "errorMsgIfNull", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "nullResult", "(Ljava/lang/String;)Ljava/lang/Object;", "tryResolving", "what", "resolver", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "winCompatiblePathOf", "path", "withCustomStdout", "", "delegateOut", "Ljava/io/PrintStream;", "task", "onEachIndexed", "C", "", "transform", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "index", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function2;)Ljava/lang/Iterable;", "partitionAroundLast", "separator", "replaceExtensionWith", "newExtension", "shared"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/javacs/kt/util/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class UtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String execAndReadStdout(@NotNull List<String> shellCommand, @NotNull Path directory) {
        Intrinsics.checkNotNullParameter(shellCommand, (String)"shellCommand");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Process process = new ProcessBuilder(shellCommand).directory(directory.toFile()).start();
        InputStream stdout = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)stdout, (String)"stdout");
        Closeable closeable = stdout;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    @NotNull
    public static final Pair<String, String> execAndReadStdoutAndStderr(@NotNull List<String> shellCommand, @NotNull Path directory) {
        Intrinsics.checkNotNullParameter(shellCommand, (String)"shellCommand");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Process process = new ProcessBuilder(shellCommand).directory(directory.toFile()).start();
        InputStream stdout = process.getInputStream();
        InputStream stderr = process.getErrorStream();
        Ref.ObjectRef output = new Ref.ObjectRef();
        output.element = "";
        Ref.ObjectRef errors = new Ref.ObjectRef();
        errors.element = "";
        Thread outputThread = new Thread(() -> UtilsKt.execAndReadStdoutAndStderr$lambda$2(stdout, output));
        Thread errorsThread = new Thread(() -> UtilsKt.execAndReadStdoutAndStderr$lambda$4(stderr, errors));
        outputThread.start();
        errorsThread.start();
        outputThread.join();
        errorsThread.join();
        return new Pair(output.element, errors.element);
    }

    public static final void withCustomStdout(@NotNull PrintStream delegateOut, @NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter((Object)delegateOut, (String)"delegateOut");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        boolean $i$f$withCustomStdout = false;
        PrintStream actualOut = System.out;
        System.setOut(delegateOut);
        task.invoke();
        System.setOut(actualOut);
    }

    @NotNull
    public static final Path winCompatiblePathOf(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.charAt(2) == ':' && path.charAt(0) == '/') {
            String string = path.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            Path path2 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path.substring(1))");
            return path2;
        }
        Path path3 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(path)");
        return path3;
    }

    @NotNull
    public static final Pair<String, String> partitionAroundLast(@NotNull String $this$partitionAroundLast, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)$this$partitionAroundLast, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        int it = StringsKt.lastIndexOf$default((CharSequence)$this$partitionAroundLast, (String)separator, (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        String string = $this$partitionAroundLast.substring(0, it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string2 = $this$partitionAroundLast.substring(it, $this$partitionAroundLast.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return new Pair((Object)string, (Object)string2);
    }

    @NotNull
    public static final Path replaceExtensionWith(@NotNull Path $this$replaceExtensionWith, @NotNull String newExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceExtensionWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newExtension, (String)"newExtension");
        String oldName = ((Object)$this$replaceExtensionWith.getFileName()).toString();
        String string = oldName.substring(0, StringsKt.lastIndexOf$default((CharSequence)oldName, (String)".", (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String newName = string + newExtension;
        Path path = $this$replaceExtensionWith.resolveSibling(newName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(newName)");
        return path;
    }

    @NotNull
    public static final <T, C extends Iterable<? extends T>> C onEachIndexed(@NotNull C $this$onEachIndexed, @NotNull Function2<? super Integer, ? super T, Unit> transform) {
        C c;
        Intrinsics.checkNotNullParameter($this$onEachIndexed, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$onEachIndexed = false;
        C $this$onEachIndexed_u24lambda_u246 = c = $this$onEachIndexed;
        boolean bl = false;
        int i = 0;
        for (T element : $this$onEachIndexed_u24lambda_u246) {
            transform.invoke((Object)i, element);
            ++i;
        }
        return c;
    }

    public static final <T> T noResult(@NotNull String message, T result) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LoggerKt.getLOG().info(message, new Object[0]);
        return result;
    }

    @NotNull
    public static final <T> CompletableFuture<T> noFuture(@NotNull String message, T contents) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CompletableFuture<T> completableFuture = UtilsKt.noResult(message, CompletableFuture.completedFuture(contents));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"noResult(message, Comple\u2026ompletedFuture(contents))");
        return completableFuture;
    }

    @NotNull
    public static final <T> List<T> emptyResult(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return UtilsKt.noResult(message, CollectionsKt.emptyList());
    }

    @Nullable
    public static final <T> T nullResult(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return UtilsKt.noResult(message, null);
    }

    @Nullable
    public static final <T> T firstNonNull(Function0<? extends T> ... optionals) {
        Intrinsics.checkNotNullParameter(optionals, (String)"optionals");
        for (Function0<? extends T> optional : optionals) {
            Object result = optional.invoke();
            if (result == null) continue;
            return (T)result;
        }
        return null;
    }

    public static final <T> T nonNull(@Nullable T item, @NotNull String errorMsgIfNull) {
        Intrinsics.checkNotNullParameter((Object)errorMsgIfNull, (String)"errorMsgIfNull");
        if (item == null) {
            throw new NullPointerException(errorMsgIfNull);
        }
        return item;
    }

    @Nullable
    public static final <T> T tryResolving(@NotNull String what, @NotNull Function0<? extends T> resolver) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        boolean $i$f$tryResolving = false;
        try {
            Object resolved = resolver.invoke();
            if (resolved != null) {
                Object[] objectArray = new Object[]{what, resolved};
                LoggerKt.getLOG().info("Successfully resolved {} to {}", objectArray);
                return (T)resolved;
            }
            Object[] objectArray = new Object[]{what};
            LoggerKt.getLOG().info("Could not resolve {} as it is null", objectArray);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{what, e.getMessage()};
            LoggerKt.getLOG().info("Could not resolve {}: {}", objectArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void execAndReadStdoutAndStderr$lambda$2(InputStream $stdout, Ref.ObjectRef $output) {
        Intrinsics.checkNotNullParameter((Object)$output, (String)"$output");
        Intrinsics.checkNotNullExpressionValue((Object)$stdout, (String)"stdout");
        Closeable closeable = $stdout;
        Object object = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            $output.element = $output.element + TextStreamsKt.readText((Reader)it);
            reader = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void execAndReadStdoutAndStderr$lambda$4(InputStream $stderr, Ref.ObjectRef $errors) {
        Intrinsics.checkNotNullParameter((Object)$errors, (String)"$errors");
        Intrinsics.checkNotNullExpressionValue((Object)$stderr, (String)"stderr");
        Closeable closeable = $stderr;
        Object object = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            $errors.element = $errors.element + TextStreamsKt.readText((Reader)it);
            reader = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }
}

