/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.util;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.util.DebouncerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\f\u001a\u00020\r2'\u0010\u000e\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\r0\u000fJ/\u0010\u0015\u001a\u00020\r2'\u0010\u000e\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\r0\u000fJ\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/javacs/kt/util/Debouncer;", "", "delay", "Ljava/time/Duration;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "<init>", "(Ljava/time/Duration;Ljava/util/concurrent/ScheduledExecutorService;)V", "delayMs", "", "pendingTask", "Ljava/util/concurrent/Future;", "submitImmediately", "", "task", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "Lkotlin/ParameterName;", "name", "cancelCallback", "schedule", "waitForPendingTask", "shutdown", "awaitTermination", "shared"})
public final class Debouncer {
    @NotNull
    private final Duration delay;
    @NotNull
    private final ScheduledExecutorService executor;
    private final long delayMs;
    @Nullable
    private Future<?> pendingTask;

    public Debouncer(@NotNull Duration delay, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.delay = delay;
        this.executor = executor;
        this.delayMs = this.delay.toMillis();
    }

    public /* synthetic */ Debouncer(Duration duration, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scheduledExecutorService = Executors.newScheduledThreadPool(1, Debouncer::_init_$lambda$0);
        }
        this(duration, scheduledExecutorService);
    }

    public final void submitImmediately(@NotNull Function1<? super Function0<Boolean>, Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Future<?> future = this.pendingTask;
        if (future != null) {
            future.cancel(false);
        }
        AtomicReference currentTaskRef = new AtomicReference();
        Future<?> currentTask = this.executor.submit(() -> Debouncer.submitImmediately$lambda$2(task, currentTaskRef));
        currentTaskRef.set(currentTask);
        this.pendingTask = currentTask;
    }

    public final void schedule(@NotNull Function1<? super Function0<Boolean>, Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Future<?> future = this.pendingTask;
        if (future != null) {
            future.cancel(false);
        }
        AtomicReference currentTaskRef = new AtomicReference();
        ScheduledFuture<?> currentTask = this.executor.schedule(() -> Debouncer.schedule$lambda$4(task, currentTaskRef), this.delayMs, TimeUnit.MILLISECONDS);
        currentTaskRef.set(currentTask);
        this.pendingTask = currentTask;
    }

    public final void waitForPendingTask() {
        block0: {
            Future<?> future = this.pendingTask;
            if (future == null) break block0;
            future.get();
        }
    }

    public final void shutdown(boolean awaitTermination) {
        this.executor.shutdown();
        if (awaitTermination) {
            LoggerKt.getLOG().info("Awaiting debouncer termination...", new Object[0]);
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
    }

    private static final Thread _init_$lambda$0(Runnable it) {
        int n = DebouncerKt.access$getThreadCount$p();
        DebouncerKt.access$setThreadCount$p(n + 1);
        return new Thread(it, "debounce" + n);
    }

    private static final boolean submitImmediately$lambda$2$lambda$1(AtomicReference $currentTaskRef) {
        Future future = (Future)$currentTaskRef.get();
        return future != null ? future.isCancelled() : false;
    }

    private static final void submitImmediately$lambda$2(Function1 $task, AtomicReference $currentTaskRef) {
        $task.invoke(() -> Debouncer.submitImmediately$lambda$2$lambda$1($currentTaskRef));
    }

    private static final boolean schedule$lambda$4$lambda$3(AtomicReference $currentTaskRef) {
        Future future = (Future)$currentTaskRef.get();
        return future != null ? future.isCancelled() : false;
    }

    private static final void schedule$lambda$4(Function1 $task, AtomicReference $currentTaskRef) {
        $task.invoke(() -> Debouncer.schedule$lambda$4$lambda$3($currentTaskRef));
    }
}

