/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.ClassPathEntry;
import org.javacs.kt.classpath.ClassPathResolver;
import org.javacs.kt.util.ShellPathUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/javacs/kt/classpath/ShellClassPathResolver;", "Lorg/javacs/kt/classpath/ClassPathResolver;", "script", "Ljava/nio/file/Path;", "workingDir", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "resolverType", "", "getResolverType", "()Ljava/lang/String;", "classpath", "", "Lorg/javacs/kt/classpath/ClassPathEntry;", "getClasspath", "()Ljava/util/Set;", "Companion", "shared"})
@SourceDebugExtension(value={"SMAP\nShellClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellClassPathResolver.kt\norg/javacs/kt/classpath/ShellClassPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class ShellClassPathResolver
implements ClassPathResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Path script;
    @Nullable
    private final Path workingDir;
    @NotNull
    private final String resolverType;
    @NotNull
    private static final List<String> configDirNames;
    @NotNull
    private static final List<String> scriptNames;
    @NotNull
    private static final List<String> scriptExtensions;
    @NotNull
    private static final Path globalConfigRoot;

    public ShellClassPathResolver(@NotNull Path script, @Nullable Path workingDir) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.script = script;
        this.workingDir = workingDir;
        this.resolverType = "Shell";
    }

    public /* synthetic */ ShellClassPathResolver(Path path, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path2 = null;
        }
        this(path, path2);
    }

    @Override
    @NotNull
    public String getResolverType() {
        return this.resolverType;
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspath() {
        Comparable<Path> comparable = this.workingDir;
        if (comparable == null || (comparable = comparable.toFile()) == null) {
            comparable = this.script.toAbsolutePath().getParent().toFile();
        }
        Comparable<Path> workingDirectory = comparable;
        String cmd = ((Object)this.script).toString();
        Object[] objectArray = new Object[]{cmd, workingDirectory};
        LoggerKt.getLOG().info("Run {} in {}", objectArray);
        String[] stringArray = new String[]{cmd};
        Process process = new ProcessBuilder(stringArray).directory((File)workingDirectory).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        stringArray = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)stringArray, charset);
        int n = 8192;
        stringArray = new String[]{File.pathSeparator};
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))), (String[])stringArray, (boolean)false, (int)0, (int)6, null)), ShellClassPathResolver::_get_classpath_$lambda$0), ShellClassPathResolver::_get_classpath_$lambda$1), ShellClassPathResolver::_get_classpath_$lambda$2));
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getClasspathOrEmpty(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspath() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspath(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspathOrEmpty(this);
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathWithSources() {
        return ClassPathResolver.DefaultImpls.getClasspathWithSources(this);
    }

    @Override
    public long getCurrentBuildFileVersion() {
        return ClassPathResolver.DefaultImpls.getCurrentBuildFileVersion(this);
    }

    private static final String _get_classpath_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean _get_classpath_$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    private static final ClassPathEntry _get_classpath_$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = Paths.get(it, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return new ClassPathEntry(path, null);
    }

    static {
        Object object;
        block6: {
            block5: {
                List list;
                Companion = new Companion(null);
                Object[] objectArray = new String[]{"kotlin-language-server", "KotlinLanguageServer"};
                configDirNames = CollectionsKt.listOf((Object[])objectArray);
                objectArray = new String[]{"kls-classpath", "kotlinLspClasspath"};
                scriptNames = CollectionsKt.listOf((Object[])objectArray);
                if (ShellPathUtilsKt.isOSWindows()) {
                    objectArray = new String[]{".bat", ".cmd", ".ps1"};
                    list = CollectionsKt.listOf((Object[])objectArray);
                } else {
                    objectArray = new String[]{"", ".sh", ".bash"};
                    list = scriptExtensions = CollectionsKt.listOf((Object[])objectArray);
                }
                if ((object = System.getenv("XDG_CONFIG_HOME")) == null) break block5;
                String it = object;
                boolean bl = false;
                Path path = Paths.get(it, new String[0]);
                object = path;
                if (path != null) break block6;
            }
            Path path = ShellPathUtilsKt.getUserHome().resolve(".config");
            object = path;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        }
        globalConfigRoot = object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/javacs/kt/classpath/ShellClassPathResolver$Companion;", "", "<init>", "()V", "configDirNames", "", "", "scriptNames", "scriptExtensions", "maybeCreate", "Lorg/javacs/kt/classpath/ShellClassPathResolver;", "file", "Ljava/nio/file/Path;", "globalConfigRoot", "global", "Lorg/javacs/kt/classpath/ClassPathResolver;", "workingDir", "shared"})
    @SourceDebugExtension(value={"SMAP\nShellClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellClassPathResolver.kt\norg/javacs/kt/classpath/ShellClassPathResolver$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1#2:64\n1755#3,3:65\n1557#3:68\n1628#3,3:69\n1368#3:72\n1454#3,2:73\n1557#3:75\n1628#3,3:76\n1456#3,3:79\n295#3,2:82\n*S KotlinDebug\n*F\n+ 1 ShellClassPathResolver.kt\norg/javacs/kt/classpath/ShellClassPathResolver$Companion\n*L\n39#1:65,3\n56#1:68\n56#1:69,3\n57#1:72\n57#1:73,2\n57#1:75\n57#1:76,3\n57#1:79,3\n58#1:82,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final ShellClassPathResolver maybeCreate(@NotNull Path file) {
            Path path;
            boolean bl;
            Path path2;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Path it = path2 = file;
            boolean bl2 = false;
            Iterable $this$any$iv = scriptNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return null;
            }
            Iterator iterator = $this$any$iv.iterator();
            block0: do {
                if (!iterator.hasNext()) return null;
                Object element$iv = iterator.next();
                String name = (String)element$iv;
                boolean bl3 = false;
                Iterable $this$any$iv2 = scriptExtensions;
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl = false;
                    continue;
                }
                for (Object element$iv2 : $this$any$iv2) {
                    String it2 = (String)element$iv2;
                    boolean bl4 = false;
                    if (!file.endsWith(name + it2)) continue;
                    bl = true;
                    continue block0;
                }
                bl = false;
            } while (!bl);
            boolean bl5 = true;
            if (!bl5) return null;
            Path path3 = path2;
            Path path4 = path3;
            if (path4 == null) return null;
            Path it3 = path = path4;
            boolean bl6 = false;
            boolean isExecutable = Files.isExecutable(it3);
            if (!isExecutable) {
                LoggerKt.getLOG().warn("Found classpath script " + it3 + " that is NOT executable and therefore cannot be used. Perhaps you'd want to chmod +x it?", new Object[0]);
            }
            if (!isExecutable) return null;
            Path path5 = path;
            path2 = path5;
            if (path2 == null) return null;
            it3 = path2;
            boolean bl7 = false;
            ShellClassPathResolver shellClassPathResolver = new ShellClassPathResolver(it3, null, 2, null);
            return shellClassPathResolver;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ClassPathResolver global(@Nullable Path workingDir) {
            ClassPathResolver classPathResolver;
            Object v0;
            block6: {
                Iterator $this$flatMapTo$iv$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = configDirNames;
                Path path = globalConfigRoot;
                boolean $i$f$map22 = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(path.resolve((String)p0));
                }
                Iterable $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                Iterable $i$f$map22 = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator $i$f$mapTo22 = $this$flatMapTo$iv$iv.iterator();
                while ($i$f$mapTo22.hasNext()) {
                    void $this$mapTo$iv$iv2;
                    Object element$iv$iv = $i$f$mapTo22.next();
                    Path root = (Path)element$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv2 = scriptExtensions;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl2 = false;
                        collection.add(root.resolve("classpath" + (String)it));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path p0 = (Path)element$iv;
                    boolean bl = false;
                    if (!Files.exists(p0, new LinkOption[0])) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            Path path = v0;
            if (path != null) {
                Path it = path;
                boolean bl = false;
                classPathResolver = new ShellClassPathResolver(it, workingDir);
            } else {
                classPathResolver = ClassPathResolver.Companion.getEmpty();
            }
            return classPathResolver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

