/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.ClassPathEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\bf\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/javacs/kt/classpath/ClassPathResolver;", "", "resolverType", "", "getResolverType", "()Ljava/lang/String;", "classpath", "", "Lorg/javacs/kt/classpath/ClassPathEntry;", "getClasspath", "()Ljava/util/Set;", "classpathOrEmpty", "getClasspathOrEmpty", "buildScriptClasspath", "Ljava/nio/file/Path;", "getBuildScriptClasspath", "buildScriptClasspathOrEmpty", "getBuildScriptClasspathOrEmpty", "classpathWithSources", "getClasspathWithSources", "currentBuildFileVersion", "", "getCurrentBuildFileVersion", "()J", "Companion", "shared"})
public interface ClassPathResolver {
    @NotNull
    public static final Companion Companion = org.javacs.kt.classpath.ClassPathResolver$Companion.$$INSTANCE;

    @NotNull
    public String getResolverType();

    @NotNull
    public Set<ClassPathEntry> getClasspath();

    @NotNull
    public Set<ClassPathEntry> getClasspathOrEmpty();

    @NotNull
    public Set<Path> getBuildScriptClasspath();

    @NotNull
    public Set<Path> getBuildScriptClasspathOrEmpty();

    @NotNull
    public Set<ClassPathEntry> getClasspathWithSources();

    public long getCurrentBuildFileVersion();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/javacs/kt/classpath/ClassPathResolver$Companion;", "", "<init>", "()V", "empty", "Lorg/javacs/kt/classpath/ClassPathResolver;", "getEmpty", "()Lorg/javacs/kt/classpath/ClassPathResolver;", "shared"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ClassPathResolver empty;

        private Companion() {
        }

        @NotNull
        public final ClassPathResolver getEmpty() {
            return empty;
        }

        static {
            $$INSTANCE = new Companion();
            empty = new ClassPathResolver(){
                private final String resolverType;
                private final Set<ClassPathEntry> classpath;
                {
                    this.resolverType = "[]";
                    this.classpath = SetsKt.emptySet();
                }

                public String getResolverType() {
                    return this.resolverType;
                }

                public Set<ClassPathEntry> getClasspath() {
                    return this.classpath;
                }

                public Set<ClassPathEntry> getClasspathOrEmpty() {
                    return DefaultImpls.getClasspathOrEmpty(this);
                }

                public Set<Path> getBuildScriptClasspath() {
                    return DefaultImpls.getBuildScriptClasspath(this);
                }

                public Set<Path> getBuildScriptClasspathOrEmpty() {
                    return DefaultImpls.getBuildScriptClasspathOrEmpty(this);
                }

                public Set<ClassPathEntry> getClasspathWithSources() {
                    return DefaultImpls.getClasspathWithSources(this);
                }

                public long getCurrentBuildFileVersion() {
                    return DefaultImpls.getCurrentBuildFileVersion(this);
                }
            };
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Set<ClassPathEntry> getClasspathOrEmpty(@NotNull ClassPathResolver $this) {
            Set set;
            try {
                set = $this.getClasspath();
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{$this.getResolverType(), e.getMessage()};
                LoggerKt.getLOG().warn("Could not resolve classpath using {}: {}", objectArray);
                set = SetsKt.emptySet();
            }
            return set;
        }

        @NotNull
        public static Set<Path> getBuildScriptClasspath(@NotNull ClassPathResolver $this) {
            return SetsKt.emptySet();
        }

        @NotNull
        public static Set<Path> getBuildScriptClasspathOrEmpty(@NotNull ClassPathResolver $this) {
            Set set;
            try {
                set = $this.getBuildScriptClasspath();
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{$this.getResolverType(), e.getMessage()};
                LoggerKt.getLOG().warn("Could not resolve buildscript classpath using {}: {}", objectArray);
                set = SetsKt.emptySet();
            }
            return set;
        }

        @NotNull
        public static Set<ClassPathEntry> getClasspathWithSources(@NotNull ClassPathResolver $this) {
            return $this.getClasspath();
        }

        public static long getCurrentBuildFileVersion(@NotNull ClassPathResolver $this) {
            return 1L;
        }
    }
}

