/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.BuildScriptClassPathCacheEntry;
import org.javacs.kt.classpath.BuildScriptClassPathCacheEntryEntity;
import org.javacs.kt.classpath.ClassPathCacheEntry;
import org.javacs.kt.classpath.ClassPathCacheEntryEntity;
import org.javacs.kt.classpath.ClassPathEntry;
import org.javacs.kt.classpath.ClassPathMetadataCache;
import org.javacs.kt.classpath.ClassPathMetadataCacheEntity;
import org.javacs.kt.classpath.ClassPathResolver;
import org.javacs.kt.classpath.ClasspathMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020)2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0002J\b\u0010/\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR0\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00130\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R(\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u00188B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0010R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0010R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00060"}, d2={"Lorg/javacs/kt/classpath/CachedClassPathResolver;", "Lorg/javacs/kt/classpath/ClassPathResolver;", "wrapped", "db", "Lorg/jetbrains/exposed/sql/Database;", "<init>", "(Lorg/javacs/kt/classpath/ClassPathResolver;Lorg/jetbrains/exposed/sql/Database;)V", "resolverType", "", "getResolverType", "()Ljava/lang/String;", "newEntries", "", "Lorg/javacs/kt/classpath/ClassPathEntry;", "cachedClassPathEntries", "getCachedClassPathEntries", "()Ljava/util/Set;", "setCachedClassPathEntries", "(Ljava/util/Set;)V", "Ljava/nio/file/Path;", "cachedBuildScriptClassPathEntries", "getCachedBuildScriptClassPathEntries", "setCachedBuildScriptClassPathEntries", "newClassPathMetadata", "Lorg/javacs/kt/classpath/ClasspathMetadata;", "cachedClassPathMetadata", "getCachedClassPathMetadata", "()Lorg/javacs/kt/classpath/ClasspathMetadata;", "setCachedClassPathMetadata", "(Lorg/javacs/kt/classpath/ClasspathMetadata;)V", "classpath", "getClasspath", "buildScriptClasspath", "getBuildScriptClasspath", "classpathWithSources", "getClasspathWithSources", "currentBuildFileVersion", "", "getCurrentBuildFileVersion", "()J", "updateClasspathCache", "", "newClasspathEntries", "includesSources", "", "updateBuildScriptClasspathCache", "newClasspath", "dependenciesChanged", "shared"})
@SourceDebugExtension(value={"SMAP\nCachedClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedClassPathResolver.kt\norg/javacs/kt/classpath/CachedClassPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1#2:178\n1557#3:179\n1628#3,3:180\n1557#3:183\n1628#3,3:184\n1557#3:187\n1628#3,3:188\n1557#3:191\n1628#3,3:192\n1557#3:195\n1628#3,3:196\n*S KotlinDebug\n*F\n+ 1 CachedClassPathResolver.kt\norg/javacs/kt/classpath/CachedClassPathResolver\n*L\n60#1:179\n60#1:180,3\n69#1:183\n69#1:184,3\n78#1:187\n78#1:188,3\n81#1:191\n81#1:192,3\n86#1:195\n86#1:196,3\n*E\n"})
public final class CachedClassPathResolver
implements ClassPathResolver {
    @NotNull
    private final ClassPathResolver wrapped;
    @NotNull
    private final Database db;

    public CachedClassPathResolver(@NotNull ClassPathResolver wrapped, @NotNull Database db) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.wrapped = wrapped;
        this.db = db;
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, CachedClassPathResolver::_init_$lambda$14);
    }

    @Override
    @NotNull
    public String getResolverType() {
        return "Cached + " + this.wrapped.getResolverType();
    }

    private final Set<ClassPathEntry> getCachedClassPathEntries() {
        return (Set)ThreadLocalTransactionManagerKt.transaction((Database)this.db, CachedClassPathResolver::_get_cachedClassPathEntries_$lambda$1);
    }

    private final void setCachedClassPathEntries(Set<ClassPathEntry> newEntries) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, arg_0 -> CachedClassPathResolver._set_cachedClassPathEntries_$lambda$4(newEntries, arg_0));
    }

    private final Set<Path> getCachedBuildScriptClassPathEntries() {
        return (Set)ThreadLocalTransactionManagerKt.transaction((Database)this.db, CachedClassPathResolver::_get_cachedBuildScriptClassPathEntries_$lambda$6);
    }

    private final void setCachedBuildScriptClassPathEntries(Set<? extends Path> newEntries) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, arg_0 -> CachedClassPathResolver._set_cachedBuildScriptClassPathEntries_$lambda$9(newEntries, arg_0));
    }

    private final ClasspathMetadata getCachedClassPathMetadata() {
        return (ClasspathMetadata)ThreadLocalTransactionManagerKt.transaction((Database)this.db, CachedClassPathResolver::_get_cachedClassPathMetadata_$lambda$11);
    }

    private final void setCachedClassPathMetadata(ClasspathMetadata newClassPathMetadata) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, arg_0 -> CachedClassPathResolver._set_cachedClassPathMetadata_$lambda$13(newClassPathMetadata, arg_0));
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspath() {
        Set<ClassPathEntry> it = this.getCachedClassPathEntries();
        boolean bl = false;
        if (!this.dependenciesChanged()) {
            LoggerKt.getLOG().info("Classpath has not changed. Fetching from cache", new Object[0]);
            return it;
        }
        LoggerKt.getLOG().info("Cached classpath is outdated or not found. Resolving again", new Object[0]);
        Set<ClassPathEntry> newClasspath = this.wrapped.getClasspath();
        this.updateClasspathCache(newClasspath, false);
        return newClasspath;
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspath() {
        if (!this.dependenciesChanged()) {
            LoggerKt.getLOG().info("Build script classpath has not changed. Fetching from cache", new Object[0]);
            return this.getCachedBuildScriptClassPathEntries();
        }
        LoggerKt.getLOG().info("Cached build script classpath is outdated or not found. Resolving again", new Object[0]);
        Set<Path> newBuildScriptClasspath = this.wrapped.getBuildScriptClasspath();
        this.updateBuildScriptClasspathCache(newBuildScriptClasspath);
        return newBuildScriptClasspath;
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathWithSources() {
        ClasspathMetadata classpathMetadata = this.getCachedClassPathMetadata();
        if (classpathMetadata != null) {
            ClasspathMetadata it = classpathMetadata;
            boolean bl = false;
            if (!this.dependenciesChanged() && it.getIncludesSources()) {
                return this.getCachedClassPathEntries();
            }
        }
        Set<ClassPathEntry> newClasspath = this.wrapped.getClasspathWithSources();
        this.updateClasspathCache(newClasspath, true);
        return newClasspath;
    }

    @Override
    public long getCurrentBuildFileVersion() {
        return this.wrapped.getCurrentBuildFileVersion();
    }

    private final void updateClasspathCache(Set<ClassPathEntry> newClasspathEntries, boolean includesSources) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, arg_0 -> CachedClassPathResolver.updateClasspathCache$lambda$17(this, newClasspathEntries, includesSources, arg_0));
    }

    private final void updateBuildScriptClasspathCache(Set<? extends Path> newClasspath) {
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, arg_0 -> CachedClassPathResolver.updateBuildScriptClasspathCache$lambda$18(this, newClasspath, arg_0));
    }

    private final boolean dependenciesChanged() {
        Object object = this.getCachedClassPathMetadata();
        return (object != null && (object = ((ClasspathMetadata)object).getBuildFileVersion()) != null ? (Long)object : 0L) < this.wrapped.getCurrentBuildFileVersion();
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getClasspathOrEmpty(this);
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspathOrEmpty() {
        return ClassPathResolver.DefaultImpls.getBuildScriptClasspathOrEmpty(this);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set _get_cachedClassPathEntries_$lambda$1(Transaction $this$transaction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Iterable $this$map$iv = (Iterable)ClassPathCacheEntryEntity.Companion.all();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Path path;
            void it;
            ClassPathCacheEntryEntity classPathCacheEntryEntity = (ClassPathCacheEntryEntity)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path2 = Paths.get(it.getCompiledJar(), new String[0]);
            Path path3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            if (it.getSourceJar() != null) {
                void p0;
                Path path4 = path3;
                boolean bl2 = false;
                path = Paths.get((String)p0, new String[0]);
                path3 = path4;
            } else {
                path = null;
            }
            Path path5 = path;
            Path path6 = path3;
            collection.add(new ClassPathEntry(path6, path5));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final Unit _set_cachedClassPathEntries_$lambda$4$lambda$3$lambda$2(ClassPathEntry $it, ClassPathCacheEntryEntity $this$new) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$new), (String)"$this$new");
        $this$new.setCompiledJar(((Object)$it.getCompiledJar()).toString());
        Path path = $it.getSourceJar();
        $this$new.setSourceJar(path != null ? ((Object)path).toString() : null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _set_cachedClassPathEntries_$lambda$4(Set $newEntries, Transaction $this$transaction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        QueriesKt.deleteAll((Table)((Table)ClassPathCacheEntry.INSTANCE));
        Iterable $this$map$iv = $newEntries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassPathEntry classPathEntry = (ClassPathEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ClassPathCacheEntryEntity)ClassPathCacheEntryEntity.Companion.new(arg_0 -> CachedClassPathResolver._set_cachedClassPathEntries_$lambda$4$lambda$3$lambda$2((ClassPathEntry)it, arg_0)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set _get_cachedBuildScriptClassPathEntries_$lambda$6(Transaction $this$transaction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Iterable $this$map$iv = (Iterable)BuildScriptClassPathCacheEntryEntity.Companion.all();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BuildScriptClassPathCacheEntryEntity buildScriptClassPathCacheEntryEntity = (BuildScriptClassPathCacheEntryEntity)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Paths.get(it.getJar(), new String[0]));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final Unit _set_cachedBuildScriptClassPathEntries_$lambda$9$lambda$8$lambda$7(Path $it, BuildScriptClassPathCacheEntryEntity $this$new) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$new), (String)"$this$new");
        $this$new.setJar(((Object)$it).toString());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _set_cachedBuildScriptClassPathEntries_$lambda$9(Set $newEntries, Transaction $this$transaction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        QueriesKt.deleteAll((Table)((Table)BuildScriptClassPathCacheEntry.INSTANCE));
        Iterable $this$map$iv = $newEntries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((BuildScriptClassPathCacheEntryEntity)BuildScriptClassPathCacheEntryEntity.Companion.new(arg_0 -> CachedClassPathResolver._set_cachedBuildScriptClassPathEntries_$lambda$9$lambda$8$lambda$7((Path)it, arg_0)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ClasspathMetadata _get_cachedClassPathMetadata_$lambda$11(Transaction $this$transaction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Iterable $this$map$iv = (Iterable)ClassPathMetadataCacheEntity.Companion.all();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassPathMetadataCacheEntity classPathMetadataCacheEntity = (ClassPathMetadataCacheEntity)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ClasspathMetadata(it.getIncludesSources(), it.getBuildFileVersion()));
        }
        return (ClasspathMetadata)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private static final Unit _set_cachedClassPathMetadata_$lambda$13$lambda$12(ClasspathMetadata $newClassPathMetadataRow, ClassPathMetadataCacheEntity $this$new) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$new), (String)"$this$new");
        $this$new.setIncludesSources($newClassPathMetadataRow.getIncludesSources());
        $this$new.setBuildFileVersion($newClassPathMetadataRow.getBuildFileVersion());
        return Unit.INSTANCE;
    }

    private static final Unit _set_cachedClassPathMetadata_$lambda$13(ClasspathMetadata $newClassPathMetadata, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        QueriesKt.deleteAll((Table)((Table)ClassPathMetadataCache.INSTANCE));
        ClasspathMetadata classpathMetadata = $newClassPathMetadata;
        if (classpathMetadata == null) {
            classpathMetadata = new ClasspathMetadata(false, null, 3, null);
        }
        ClasspathMetadata newClassPathMetadataRow = classpathMetadata;
        ClassPathMetadataCacheEntity.Companion.new(arg_0 -> CachedClassPathResolver._set_cachedClassPathMetadata_$lambda$13$lambda$12(newClassPathMetadataRow, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$14(Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{ClassPathMetadataCache.INSTANCE, ClassPathCacheEntry.INSTANCE, BuildScriptClassPathCacheEntry.INSTANCE};
        SchemaUtils.createMissingTablesAndColumns$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (boolean)false, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit updateClasspathCache$lambda$17(CachedClassPathResolver this$0, Set $newClasspathEntries, boolean $includesSources, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        this$0.setCachedClassPathEntries($newClasspathEntries);
        ClasspathMetadata classpathMetadata = this$0.getCachedClassPathMetadata();
        if (classpathMetadata == null || (classpathMetadata = classpathMetadata.copy($includesSources, this$0.getCurrentBuildFileVersion())) == null) {
            classpathMetadata = new ClasspathMetadata(false, null, 3, null);
        }
        this$0.setCachedClassPathMetadata(classpathMetadata);
        return Unit.INSTANCE;
    }

    private static final Unit updateBuildScriptClasspathCache$lambda$18(CachedClassPathResolver this$0, Set $newClasspath, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        this$0.setCachedBuildScriptClassPathEntries($newClasspath);
        ClasspathMetadata classpathMetadata = this$0.getCachedClassPathMetadata();
        if (classpathMetadata == null || (classpathMetadata = ClasspathMetadata.copy$default(classpathMetadata, false, this$0.getCurrentBuildFileVersion(), 1, null)) == null) {
            classpathMetadata = new ClasspathMetadata(false, null, 3, null);
        }
        this$0.setCachedClassPathMetadata(classpathMetadata);
        return Unit.INSTANCE;
    }
}

