/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.database.DatabaseService;
import org.javacs.kt.index.ExtractSymbolExtensionReceiverType;
import org.javacs.kt.index.ExtractSymbolKind;
import org.javacs.kt.index.ExtractSymbolVisibility;
import org.javacs.kt.index.Symbol;
import org.javacs.kt.index.SymbolEntity;
import org.javacs.kt.index.SymbolIndex;
import org.javacs.kt.index.Symbols;
import org.javacs.kt.progress.Progress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SQLExpressionBuilderKt;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001bH\u0002J\u001e\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J4\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020$J\u001c\u0010)\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0016\u0010*\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\"\u0010+\u001a\u00020\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"Lorg/javacs/kt/index/SymbolIndex;", "", "databaseService", "Lorg/javacs/kt/database/DatabaseService;", "(Lorg/javacs/kt/database/DatabaseService;)V", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "db$delegate", "Lkotlin/Lazy;", "progressFactory", "Lorg/javacs/kt/progress/Progress$Factory;", "getProgressFactory", "()Lorg/javacs/kt/progress/Progress$Factory;", "setProgressFactory", "(Lorg/javacs/kt/progress/Progress$Factory;)V", "addDeclarations", "", "declarations", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "allDescriptors", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "exclusions", "allPackages", "Lorg/jetbrains/kotlin/name/FqName;", "pkgName", "getFqNames", "Lkotlin/Pair;", "declaration", "query", "", "Lorg/javacs/kt/index/Symbol;", "prefix", "", "receiverType", "limit", "", "suffix", "refresh", "removeDeclarations", "updateIndexes", "remove", "add", "validFqName", "", "fqName", "server"})
@SourceDebugExtension(value={"SMAP\nSymbolIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolIndex.kt\norg/javacs/kt/index/SymbolIndex\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1313#2:219\n1314#2:221\n1313#2,2:222\n1#3:220\n*S KotlinDebug\n*F\n+ 1 SymbolIndex.kt\norg/javacs/kt/index/SymbolIndex\n*L\n146#1:219\n146#1:221\n159#1:222,2\n*E\n"})
public final class SymbolIndex {
    @NotNull
    private final DatabaseService databaseService;
    @NotNull
    private final Lazy db$delegate;
    @NotNull
    private Progress.Factory progressFactory;

    public SymbolIndex(@NotNull DatabaseService databaseService) {
        Intrinsics.checkNotNullParameter((Object)databaseService, (String)"databaseService");
        this.databaseService = databaseService;
        this.db$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Database>(this){
            final /* synthetic */ SymbolIndex this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Database invoke() {
                Database database = SymbolIndex.access$getDatabaseService$p(this.this$0).getDb();
                if (database == null) {
                    database = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)"jdbc:h2:mem:symbolindex;DB_CLOSE_DELAY=-1", (String)"org.h2.Driver", null, null, null, null, null, (int)124, null);
                }
                return database;
            }
        }));
        this.progressFactory = Progress.Factory.None.INSTANCE;
        ThreadLocalTransactionManagerKt.transaction((Database)this.getDb(), (Function1)1.INSTANCE);
    }

    private final Database getDb() {
        Lazy lazy = this.db$delegate;
        return (Database)lazy.getValue();
    }

    @NotNull
    public final Progress.Factory getProgressFactory() {
        return this.progressFactory;
    }

    public final void setProgressFactory(@NotNull Progress.Factory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"<set-?>");
        this.progressFactory = factory;
    }

    public final void refresh(@NotNull ModuleDescriptor module, @NotNull Sequence<? extends DeclarationDescriptor> exclusions) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(exclusions, (String)"exclusions");
        long started = System.currentTimeMillis();
        LoggerKt.getLOG().info("Updating full symbol index...", new Object[0]);
        this.progressFactory.create("Indexing").thenApplyAsync(arg_0 -> SymbolIndex.refresh$lambda$0((Function1)new Function1<Progress, Unit>(this, module, exclusions, started){
            final /* synthetic */ SymbolIndex this$0;
            final /* synthetic */ ModuleDescriptor $module;
            final /* synthetic */ Sequence<DeclarationDescriptor> $exclusions;
            final /* synthetic */ long $started;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                this.$exclusions = $exclusions;
                this.$started = $started;
                super(1);
            }

            public final void invoke(Progress progress) {
                try {
                    ThreadLocalTransactionManagerKt.transaction((Database)SymbolIndex.access$getDb(this.this$0), (Function1)((Function1)new Function1<Transaction, Unit>(this.this$0, this.$module, this.$exclusions, this.$started){
                        final /* synthetic */ SymbolIndex this$0;
                        final /* synthetic */ ModuleDescriptor $module;
                        final /* synthetic */ Sequence<DeclarationDescriptor> $exclusions;
                        final /* synthetic */ long $started;
                        {
                            this.this$0 = $receiver;
                            this.$module = $module;
                            this.$exclusions = $exclusions;
                            this.$started = $started;
                            super(1);
                        }

                        public final void invoke(@NotNull Transaction $this$transaction) {
                            Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                            QueriesKt.deleteAll((Table)((Table)Symbols.INSTANCE));
                            SymbolIndex.access$addDeclarations(this.this$0, SymbolIndex.access$allDescriptors(this.this$0, this.$module, this.$exclusions));
                            long finished = System.currentTimeMillis();
                            long count = ((Number)((ResultRow)CollectionsKt.first((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)Symbols.INSTANCE.slice((Expression)SQLExpressionBuilderKt.count((ExpressionWithColumnType)((ExpressionWithColumnType)Symbols.INSTANCE.getFqName())), new Expression[0]))))).get((Expression)SQLExpressionBuilderKt.count((ExpressionWithColumnType)((ExpressionWithColumnType)Symbols.INSTANCE.getFqName())))).longValue();
                            LoggerKt.getLOG().info("Updated full symbol index in " + (finished - this.$started) + " ms! (" + count + " symbol(s))", new Object[0]);
                        }
                    }));
                }
                catch (Exception e) {
                    LoggerKt.getLOG().error("Error while updating symbol index", new Object[0]);
                    LoggerKt.getLOG().printStackTrace((Throwable)e);
                }
                progress.close();
            }
        }, arg_0));
    }

    public final void updateIndexes(@NotNull Sequence<? extends DeclarationDescriptor> remove, @NotNull Sequence<? extends DeclarationDescriptor> add) {
        Intrinsics.checkNotNullParameter(remove, (String)"remove");
        Intrinsics.checkNotNullParameter(add, (String)"add");
        long started = System.currentTimeMillis();
        LoggerKt.getLOG().info("Updating symbol index...", new Object[0]);
        try {
            ThreadLocalTransactionManagerKt.transaction((Database)this.getDb(), (Function1)((Function1)new Function1<Transaction, Unit>(this, remove, add, started){
                final /* synthetic */ SymbolIndex this$0;
                final /* synthetic */ Sequence<DeclarationDescriptor> $remove;
                final /* synthetic */ Sequence<DeclarationDescriptor> $add;
                final /* synthetic */ long $started;
                {
                    this.this$0 = $receiver;
                    this.$remove = $remove;
                    this.$add = $add;
                    this.$started = $started;
                    super(1);
                }

                public final void invoke(@NotNull Transaction $this$transaction) {
                    Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                    SymbolIndex.access$removeDeclarations(this.this$0, this.$remove);
                    SymbolIndex.access$addDeclarations(this.this$0, this.$add);
                    long finished = System.currentTimeMillis();
                    long count = ((Number)((ResultRow)CollectionsKt.first((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)Symbols.INSTANCE.slice((Expression)SQLExpressionBuilderKt.count((ExpressionWithColumnType)((ExpressionWithColumnType)Symbols.INSTANCE.getFqName())), new Expression[0]))))).get((Expression)SQLExpressionBuilderKt.count((ExpressionWithColumnType)((ExpressionWithColumnType)Symbols.INSTANCE.getFqName())))).longValue();
                    LoggerKt.getLOG().info("Updated symbol index in " + (finished - this.$started) + " ms! (" + count + " symbol(s))", new Object[0]);
                }
            }));
        }
        catch (Exception e) {
            LoggerKt.getLOG().error("Error while updating symbol index", new Object[0]);
            LoggerKt.getLOG().printStackTrace((Throwable)e);
        }
    }

    private final void removeDeclarations(Sequence<? extends DeclarationDescriptor> declarations) {
        Sequence<? extends DeclarationDescriptor> $this$forEach$iv = declarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarationDescriptor declaration = (DeclarationDescriptor)element$iv;
            boolean bl = false;
            Pair<FqName, FqName> pair = this.getFqNames(declaration);
            FqName descriptorFqn = (FqName)pair.component1();
            FqName extensionReceiverFqn = (FqName)pair.component2();
            if (this.validFqName(descriptorFqn)) {
                boolean bl2;
                if (extensionReceiverFqn != null) {
                    FqName it;
                    boolean bl3 = false;
                    bl2 = !this.validFqName(it);
                } else {
                    bl2 = false;
                }
                if (!bl2) {
                    QueriesKt.deleteWhere$default((Table)((Table)Symbols.INSTANCE), null, null, (Function1)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(descriptorFqn, extensionReceiverFqn){
                        final /* synthetic */ FqName $descriptorFqn;
                        final /* synthetic */ FqName $extensionReceiverFqn;
                        {
                            this.$descriptorFqn = $descriptorFqn;
                            this.$extensionReceiverFqn = $extensionReceiverFqn;
                            super(1);
                        }

                        @NotNull
                        public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$deleteWhere) {
                            Intrinsics.checkNotNullParameter((Object)$this$deleteWhere, (String)"$this$deleteWhere");
                            ExpressionWithColumnType expressionWithColumnType = (ExpressionWithColumnType)Symbols.INSTANCE.getFqName();
                            String string = this.$descriptorFqn.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                            FqName fqName = this.$extensionReceiverFqn;
                            return OpKt.and((Expression)((Expression)$this$deleteWhere.eq(expressionWithColumnType, (Object)string)), (Expression)((Expression)$this$deleteWhere.eq((ExpressionWithColumnType)Symbols.INSTANCE.getExtensionReceiverType(), (Object)(fqName != null ? fqName.toString() : null))));
                        }
                    }), (int)3, null);
                    continue;
                }
            }
            Object[] objectArray = new Object[]{descriptorFqn.toString()};
            LoggerKt.getLOG().warn("Excluding symbol {} from index since its name is too long", objectArray);
        }
    }

    private final void addDeclarations(Sequence<? extends DeclarationDescriptor> declarations) {
        Sequence<? extends DeclarationDescriptor> $this$forEach$iv = declarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarationDescriptor declaration = (DeclarationDescriptor)element$iv;
            boolean bl = false;
            Pair<FqName, FqName> pair = this.getFqNames(declaration);
            FqName descriptorFqn = (FqName)pair.component1();
            FqName extensionReceiverFqn = (FqName)pair.component2();
            if (this.validFqName(descriptorFqn)) {
                boolean bl2;
                if (extensionReceiverFqn != null) {
                    FqName it;
                    boolean bl3 = false;
                    bl2 = !this.validFqName(it);
                } else {
                    bl2 = false;
                }
                if (!bl2) {
                    SymbolEntity.Companion.new((Function1)new Function1<SymbolEntity, Unit>(descriptorFqn, declaration, extensionReceiverFqn){
                        final /* synthetic */ FqName $descriptorFqn;
                        final /* synthetic */ DeclarationDescriptor $declaration;
                        final /* synthetic */ FqName $extensionReceiverFqn;
                        {
                            this.$descriptorFqn = $descriptorFqn;
                            this.$declaration = $declaration;
                            this.$extensionReceiverFqn = $extensionReceiverFqn;
                            super(1);
                        }

                        public final void invoke(@NotNull SymbolEntity $this$new) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$this$new), (String)"$this$new");
                            String string = this.$descriptorFqn.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                            $this$new.setFqName(string);
                            String string2 = this.$descriptorFqn.shortName().toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                            $this$new.setShortName(string2);
                            $this$new.setKind(((Symbol.Kind)((Object)this.$declaration.accept((DeclarationDescriptorVisitor)ExtractSymbolKind.INSTANCE, (Object)Unit.INSTANCE))).getRawValue());
                            $this$new.setVisibility(((Symbol.Visibility)((Object)this.$declaration.accept((DeclarationDescriptorVisitor)ExtractSymbolVisibility.INSTANCE, (Object)Unit.INSTANCE))).getRawValue());
                            FqName fqName = this.$extensionReceiverFqn;
                            $this$new.setExtensionReceiverType(fqName != null ? fqName.toString() : null);
                        }
                    });
                    continue;
                }
            }
            Object[] objectArray = new Object[]{descriptorFqn.toString()};
            LoggerKt.getLOG().warn("Excluding symbol {} from index since its name is too long", objectArray);
        }
    }

    private final Pair<FqName, FqName> getFqNames(DeclarationDescriptor declaration) {
        Object object;
        FqName descriptorFqn = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declaration);
        FqName fqName = (FqName)declaration.accept((DeclarationDescriptorVisitor)ExtractSymbolExtensionReceiverType.INSTANCE, (Object)Unit.INSTANCE);
        if (fqName != null) {
            FqName fqName2;
            FqName it = fqName2 = fqName;
            boolean bl = false;
            object = !it.isRoot() ? fqName2 : null;
        } else {
            object = null;
        }
        FqName extensionReceiverFqn = object;
        return new Pair((Object)descriptorFqn, extensionReceiverFqn);
    }

    private final boolean validFqName(FqName fqName) {
        return fqName.toString().length() <= 255 && fqName.shortName().toString().length() <= 80;
    }

    @NotNull
    public final List<Symbol> query(@NotNull String prefix, @Nullable FqName receiverType, int limit, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return (List)ThreadLocalTransactionManagerKt.transaction((Database)this.getDb(), (Function1)((Function1)new Function1<Transaction, List<? extends Symbol>>(limit, prefix, suffix, receiverType){
            final /* synthetic */ int $limit;
            final /* synthetic */ String $prefix;
            final /* synthetic */ String $suffix;
            final /* synthetic */ FqName $receiverType;
            {
                this.$limit = $limit;
                this.$prefix = $prefix;
                this.$suffix = $suffix;
                this.$receiverType = $receiverType;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Symbol> invoke(@NotNull Transaction $this$transaction) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                Iterable $this$map$iv = (Iterable)SizedIterable.DefaultImpls.limit$default((SizedIterable)SymbolEntity.Companion.find((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(this.$prefix, this.$suffix, this.$receiverType){
                    final /* synthetic */ String $prefix;
                    final /* synthetic */ String $suffix;
                    final /* synthetic */ FqName $receiverType;
                    {
                        this.$prefix = $prefix;
                        this.$suffix = $suffix;
                        this.$receiverType = $receiverType;
                        super(1);
                    }

                    @NotNull
                    public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                        FqName fqName = this.$receiverType;
                        return OpKt.and((Expression)((Expression)$this$find.like((Expression)Symbols.INSTANCE.getShortName(), this.$prefix + this.$suffix)), (Expression)((Expression)$this$find.eq((ExpressionWithColumnType)Symbols.INSTANCE.getExtensionReceiverType(), (Object)(fqName != null ? fqName.toString() : null))));
                    }
                }), (int)this.$limit, (long)0L, (int)2, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    FqName fqName;
                    void it;
                    SymbolEntity symbolEntity = (SymbolEntity)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    FqName fqName2 = new FqName(it.getFqName());
                    Symbol.Kind kind = Symbol.Kind.Companion.fromRaw(it.getKind());
                    Symbol.Visibility visibility = Symbol.Visibility.Companion.fromRaw(it.getVisibility());
                    if (it.getExtensionReceiverType() != null) {
                        void p0;
                        Symbol.Visibility visibility2 = visibility;
                        Symbol.Kind kind2 = kind;
                        FqName fqName3 = fqName2;
                        boolean bl2 = false;
                        FqName fqName4 = new FqName((String)p0);
                        fqName2 = fqName3;
                        kind = kind2;
                        visibility = visibility2;
                        fqName = fqName4;
                    } else {
                        fqName = null;
                    }
                    FqName fqName5 = fqName;
                    Symbol.Visibility visibility3 = visibility;
                    Symbol.Kind kind3 = kind;
                    FqName fqName6 = fqName2;
                    collection.add(new Symbol(fqName6, kind3, visibility3, fqName5));
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    public static /* synthetic */ List query$default(SymbolIndex symbolIndex, String string, FqName fqName, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fqName = null;
        }
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            string2 = "%";
        }
        return symbolIndex.query(string, fqName, n, string2);
    }

    private final Sequence<DeclarationDescriptor> allDescriptors(ModuleDescriptor module, Sequence<? extends DeclarationDescriptor> exclusions) {
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)SymbolIndex.allPackages$default(this, module, null, 2, null), (Function1)((Function1)new Function1<FqName, PackageViewDescriptor>((Object)module){

            @NotNull
            public final PackageViewDescriptor invoke(@NotNull FqName p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ModuleDescriptor)this.receiver).getPackage(p0);
            }
        })), (Function1)((Function1)new Function1<PackageViewDescriptor, Collection<? extends DeclarationDescriptor>>(exclusions){
            final /* synthetic */ Sequence<DeclarationDescriptor> $exclusions;
            {
                this.$exclusions = $exclusions;
                super(1);
            }

            @NotNull
            public final Collection<DeclarationDescriptor> invoke(@NotNull PackageViewDescriptor it) {
                Collection collection;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    collection = it.getMemberScope().getContributedDescriptors(DescriptorKindFilter.ALL, (Function1)new Function1<Name, Boolean>(this.$exclusions){
                        final /* synthetic */ Sequence<DeclarationDescriptor> $exclusions;
                        {
                            this.$exclusions = $exclusions;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull Name name) {
                            boolean bl;
                            block1: {
                                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                                Sequence<DeclarationDescriptor> $this$any$iv = this.$exclusions;
                                boolean $i$f$any = false;
                                for (E element$iv : $this$any$iv) {
                                    DeclarationDescriptor declaration = (DeclarationDescriptor)element$iv;
                                    boolean bl2 = false;
                                    if (!Intrinsics.areEqual((Object)declaration.getName(), (Object)name)) continue;
                                    bl = true;
                                    break block1;
                                }
                                bl = false;
                            }
                            return !bl;
                        }
                    });
                }
                catch (IllegalStateException e) {
                    LoggerKt.getLOG().warn("Could not query descriptors in package " + it, new Object[0]);
                    collection = CollectionsKt.emptyList();
                }
                return collection;
            }
        }));
    }

    private final Sequence<FqName> allPackages(ModuleDescriptor module, FqName pkgName) {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)module.getSubPackagesOf(pkgName, (Function1)allPackages.1.INSTANCE)), (Function1)((Function1)new Function1<FqName, Sequence<? extends FqName>>(this, module){
            final /* synthetic */ SymbolIndex this$0;
            final /* synthetic */ ModuleDescriptor $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super(1);
            }

            @NotNull
            public final Sequence<FqName> invoke(@NotNull FqName it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object[] objectArray = new FqName[]{it};
                return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Sequence)SymbolIndex.access$allPackages(this.this$0, this.$module, it));
            }
        }));
    }

    static /* synthetic */ Sequence allPackages$default(SymbolIndex symbolIndex, ModuleDescriptor moduleDescriptor, FqName fqName, int n, Object object) {
        if ((n & 2) != 0) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ROOT");
            fqName = fqName2;
        }
        return symbolIndex.allPackages(moduleDescriptor, fqName);
    }

    private static final Unit refresh$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Database access$getDb(SymbolIndex $this) {
        return $this.getDb();
    }

    public static final /* synthetic */ void access$addDeclarations(SymbolIndex $this, Sequence declarations) {
        $this.addDeclarations((Sequence<? extends DeclarationDescriptor>)declarations);
    }

    public static final /* synthetic */ Sequence access$allDescriptors(SymbolIndex $this, ModuleDescriptor module, Sequence exclusions) {
        return $this.allDescriptors(module, (Sequence<? extends DeclarationDescriptor>)exclusions);
    }

    public static final /* synthetic */ void access$removeDeclarations(SymbolIndex $this, Sequence declarations) {
        $this.removeDeclarations((Sequence<? extends DeclarationDescriptor>)declarations);
    }

    public static final /* synthetic */ Sequence access$allPackages(SymbolIndex $this, ModuleDescriptor module, FqName pkgName) {
        return $this.allPackages(module, pkgName);
    }

    public static final /* synthetic */ DatabaseService access$getDatabaseService$p(SymbolIndex $this) {
        return $this.databaseService;
    }
}

