/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model.config;

import groovy.lang.MetaProperty;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.ValueGenerator;
import org.grails.datastore.mapping.model.config.GormMappingConfigurationStrategy;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.ToMany;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;

public class JpaMappingConfigurationStrategy
extends GormMappingConfigurationStrategy {
    public JpaMappingConfigurationStrategy(MappingFactory propertyFactory) {
        super(propertyFactory);
    }

    private boolean isJpaEntity(Class clazz) {
        return clazz.isAnnotationPresent(Entity.class);
    }

    @Override
    public List<PersistentProperty> getPersistentProperties(PersistentEntity entity, MappingContext context, ClassMapping classMapping, boolean includeIdentifiers) {
        Class entityClass = entity.getJavaClass();
        if (!this.isJpaEntity(entityClass)) {
            return super.getPersistentProperties(entity, context, classMapping, includeIdentifiers);
        }
        ArrayList<PersistentProperty> persistentProperties = new ArrayList<PersistentProperty>();
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(entityClass);
        for (MetaProperty metaProperty : cpf.getMetaProperties()) {
            Association association;
            Field field;
            PropertyDescriptor descriptor = this.propertyFactory.createPropertyDescriptor(entityClass, metaProperty);
            if (descriptor == null || descriptor.getPropertyType() == null || descriptor.getPropertyType() == Object.class || descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null) continue;
            String propertyName = descriptor.getName();
            Method readMethod = descriptor.getReadMethod();
            try {
                field = cpf.getDeclaredField(descriptor.getName());
            }
            catch (Exception e) {
                continue;
            }
            if (this.hasAnnotation(readMethod, field, Transient.class) || this.isExcludedProperty(propertyName, classMapping, new ArrayList(), includeIdentifiers)) continue;
            Class<?> propertyType = descriptor.getPropertyType();
            if (this.hasAnnotation(readMethod, field, Id.class)) {
                persistentProperties.add(this.propertyFactory.createIdentity(entity, context, descriptor));
                continue;
            }
            if (this.hasAnnotation(readMethod, field, EmbeddedId.class)) {
                persistentProperties.add(this.propertyFactory.createIdentity(entity, context, descriptor));
                continue;
            }
            if (this.hasAnnotation(readMethod, field, Embedded.class)) {
                if (this.isCollectionType(propertyType)) {
                    association = this.establishRelationshipForCollection(descriptor, field, entity, context, true);
                    if (association == null) continue;
                    persistentProperties.add(association);
                    continue;
                }
                association = this.establishDomainClassRelationship(entity, descriptor, field, context, true);
                if (association == null) continue;
                persistentProperties.add(association);
                continue;
            }
            if (this.isCollectionType(propertyType)) {
                association = this.establishRelationshipForCollection(descriptor, field, entity, context, false);
                if (association == null) continue;
                this.configureOwningSide(association);
                persistentProperties.add(association);
                continue;
            }
            if (this.isPersistentEntity(propertyType)) {
                association = this.establishDomainClassRelationship(entity, descriptor, field, context, false);
                if (association == null) continue;
                this.configureOwningSide(association);
                persistentProperties.add(association);
                continue;
            }
            if (this.propertyFactory.isSimpleType(propertyType)) {
                Simple simpleProperty = this.propertyFactory.createSimple(entity, context, descriptor);
                if (this.hasAnnotation(readMethod, field, GeneratedValue.class)) {
                    ((Property)simpleProperty.getMapping().getMappedForm()).setDerived(true);
                }
                persistentProperties.add(simpleProperty);
                continue;
            }
            if (!this.supportsCustomType(propertyType)) continue;
            persistentProperties.add(this.propertyFactory.createCustom(entity, context, descriptor));
        }
        return persistentProperties;
    }

    protected Association establishRelationshipForCollection(PropertyDescriptor property, Field field, PersistentEntity entity, MappingContext context, boolean embedded) {
        Class javaClass = entity.getJavaClass();
        Class genericClass = MappingUtils.getGenericTypeForProperty(javaClass, property.getName());
        Class relatedClassType = null;
        if (genericClass != null) {
            relatedClassType = genericClass;
        }
        if (relatedClassType == null) {
            return this.propertyFactory.createBasicCollection(entity, context, property);
        }
        if (embedded) {
            if (this.propertyFactory.isSimpleType(relatedClassType)) {
                return this.propertyFactory.createBasicCollection(entity, context, property, relatedClassType);
            }
            EmbeddedCollection association = this.propertyFactory.createEmbeddedCollection(entity, context, property);
            PersistentEntity associatedEntity = this.getOrCreateEmbeddedEntity(entity, context, relatedClassType);
            association.setAssociatedEntity(associatedEntity);
            return association;
        }
        if (!this.isPersistentEntity(relatedClassType) && !relatedClassType.equals(entity.getJavaClass())) {
            return this.propertyFactory.createBasicCollection(entity, context, property, relatedClassType);
        }
        ClassPropertyFetcher referencedCpf = ClassPropertyFetcher.forClass(relatedClassType);
        String referencedPropertyName = null;
        Method readMethod = property.getReadMethod();
        ToMany association = null;
        if (this.hasAnnotation(readMethod, field, ManyToMany.class)) {
            association = this.propertyFactory.createManyToMany(entity, context, property);
            ManyToMany manyToMany = this.getAnnotation(readMethod, field, ManyToMany.class);
            if (!manyToMany.mappedBy().equals("")) {
                ((org.grails.datastore.mapping.model.types.ManyToMany)association).setInversePropertyName(manyToMany.mappedBy());
                referencedPropertyName = manyToMany.mappedBy();
            } else {
                List<PropertyDescriptor> descriptors = referencedCpf.getPropertiesAssignableToType(Collection.class);
                if (descriptors.size() > 0) {
                    for (PropertyDescriptor descriptor : descriptors) {
                        Class relatedGenericClass = MappingUtils.getGenericTypeForProperty(relatedClassType, descriptor.getName());
                        ManyToMany relatedManyToMany = this.getAnnotation(referencedCpf, descriptor, ManyToMany.class);
                        if (relatedGenericClass == null && relatedManyToMany != null) {
                            relatedGenericClass = relatedManyToMany.targetEntity();
                        }
                        if (relatedGenericClass != javaClass || relatedManyToMany == null || !relatedManyToMany.mappedBy().equals(property.getName())) continue;
                        entity.addOwner(relatedClassType);
                        referencedPropertyName = descriptor.getName();
                        break;
                    }
                }
            }
        } else if (this.hasAnnotation(readMethod, field, OneToMany.class)) {
            association = this.propertyFactory.createOneToMany(entity, context, property);
            OneToMany oneToMany = this.getAnnotation(readMethod, field, OneToMany.class);
            if (!oneToMany.mappedBy().equals("")) {
                referencedPropertyName = oneToMany.mappedBy();
            }
        }
        if (association != null) {
            PersistentEntity associatedEntity = this.getOrCreateAssociatedEntity(entity, context, relatedClassType);
            association.setAssociatedEntity(associatedEntity);
            if (referencedPropertyName != null) {
                association.setReferencedPropertyName(referencedPropertyName);
            }
        }
        return association;
    }

    private ToOne establishDomainClassRelationship(PersistentEntity entity, PropertyDescriptor property, Field field, MappingContext context, boolean embedded) {
        ToOne association = null;
        Class<?> propType = property.getPropertyType();
        if (embedded) {
            PersistentEntity associatedEntity = this.getOrCreateEmbeddedEntity(entity, context, propType);
            association = this.propertyFactory.createEmbedded(entity, context, property);
            association.setAssociatedEntity(associatedEntity);
            return association;
        }
        ClassPropertyFetcher relatedCpf = ClassPropertyFetcher.forClass(propType);
        String relatedClassPropertyName = null;
        Method readMethod = property.getReadMethod();
        if (this.getAnnotation(readMethod, field, ManyToOne.class) != null) {
            association = this.propertyFactory.createManyToOne(entity, context, property);
            List<PropertyDescriptor> descriptors = relatedCpf.getPropertiesAssignableToType(Collection.class);
            association.setForeignKeyInChild(true);
            if (descriptors.size() > 0) {
                for (PropertyDescriptor descriptor : descriptors) {
                    Class genericClass = MappingUtils.getGenericTypeForProperty(propType, descriptor.getName());
                    OneToMany relatedOneToMany = this.getAnnotation(relatedCpf, descriptor, OneToMany.class);
                    if (genericClass == null && relatedOneToMany != null) {
                        genericClass = relatedOneToMany.targetEntity();
                    }
                    if (genericClass != entity.getJavaClass() || relatedOneToMany == null || !relatedOneToMany.mappedBy().equals(property.getName())) continue;
                    association.setForeignKeyInChild(false);
                    entity.addOwner(propType);
                    relatedClassPropertyName = descriptor.getName();
                    break;
                }
            }
        } else {
            OneToOne oneToOne = this.getAnnotation(readMethod, field, OneToOne.class);
            if (oneToOne != null) {
                if (!oneToOne.mappedBy().equals("")) {
                    relatedClassPropertyName = oneToOne.mappedBy();
                }
                association = this.propertyFactory.createOneToOne(entity, context, property);
                association.setForeignKeyInChild(true);
                List<PropertyDescriptor> descriptors = relatedCpf.getPropertiesOfType(entity.getJavaClass());
                if (descriptors.size() > 0) {
                    for (PropertyDescriptor descriptor : descriptors) {
                        OneToOne relatedOneToOne = this.getAnnotation(relatedCpf, descriptor, OneToOne.class);
                        if (relatedOneToOne == null || !relatedOneToOne.mappedBy().equals(property.getName())) continue;
                        association.setForeignKeyInChild(false);
                        entity.addOwner(propType);
                        relatedClassPropertyName = descriptor.getName();
                        break;
                    }
                }
            }
        }
        if (association != null) {
            PersistentEntity associatedEntity = this.getOrCreateAssociatedEntity(entity, context, propType);
            association.setAssociatedEntity(associatedEntity);
            if (relatedClassPropertyName != null) {
                association.setReferencedPropertyName(relatedClassPropertyName);
            }
        }
        return association;
    }

    @Override
    public IdentityMapping getIdentityMapping(final ClassMapping classMapping) {
        final PersistentEntity entity = classMapping.getEntity();
        if (!this.isJpaEntity(entity.getJavaClass())) {
            return super.getIdentityMapping(classMapping);
        }
        return new IdentityMapping(){
            String[] idPropertiesArray;

            @Override
            public String[] getIdentifierName() {
                if (this.idPropertiesArray != null) {
                    return this.idPropertiesArray;
                }
                ArrayList<String> idProperties = new ArrayList<String>();
                ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(entity.getJavaClass());
                for (MetaProperty metaProperty : cpf.getMetaProperties()) {
                    PropertyDescriptor pd;
                    int modifiers = metaProperty.getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || (pd = JpaMappingConfigurationStrategy.this.propertyFactory.createPropertyDescriptor(entity.getJavaClass(), metaProperty)) == null) continue;
                    if (JpaMappingConfigurationStrategy.this.hasAnnotation(cpf, pd, Id.class)) {
                        idProperties.add(metaProperty.getName());
                        continue;
                    }
                    if (!JpaMappingConfigurationStrategy.this.hasAnnotation(cpf, pd, EmbeddedId.class)) continue;
                    idProperties.add(metaProperty.getName());
                }
                if (idProperties.isEmpty()) {
                    idProperties.add("id");
                }
                this.idPropertiesArray = idProperties.toArray(new String[idProperties.size()]);
                return this.idPropertiesArray;
            }

            @Override
            public ValueGenerator getGenerator() {
                return ValueGenerator.AUTO;
            }

            @Override
            public ClassMapping getClassMapping() {
                return classMapping;
            }

            public Property getMappedForm() {
                return classMapping.getEntity().getIdentity().getMapping().getMappedForm();
            }
        };
    }

    <A extends Annotation> boolean hasAnnotation(Method method, Field field, Class<A> type) {
        return method != null && method.isAnnotationPresent(type) || field != null && field.isAnnotationPresent(type);
    }

    <A extends Annotation> A getAnnotation(Method method, Field field, Class<A> type) {
        if (method != null && method.isAnnotationPresent(type)) {
            return method.getAnnotation(type);
        }
        if (field != null && field.isAnnotationPresent(type)) {
            return field.getAnnotation(type);
        }
        return null;
    }

    <A extends Annotation> boolean hasAnnotation(ClassPropertyFetcher cpf, PropertyDescriptor descriptor, Class<A> type) {
        Method readMethod = descriptor.getReadMethod();
        if (readMethod != null && readMethod.isAnnotationPresent(type)) {
            return true;
        }
        Field field = cpf.getDeclaredField(descriptor.getName());
        return field != null && field.isAnnotationPresent(type);
    }

    <A extends Annotation> A getAnnotation(ClassPropertyFetcher cpf, PropertyDescriptor descriptor, Class<A> type) {
        Method readMethod = descriptor.getReadMethod();
        if (readMethod != null && readMethod.isAnnotationPresent(type)) {
            return readMethod.getAnnotation(type);
        }
        Field field = cpf.getDeclaredField(descriptor.getName());
        if (field != null && field.isAnnotationPresent(type)) {
            return field.getAnnotation(type);
        }
        return null;
    }
}

