/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.util.ChecksumUtils;

@Singleton
@Named
public class DefaultFileProcessor
implements FileProcessor {
    public boolean mkdirs(File directory) {
        File canonDir;
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File target, String data) throws IOException {
        this.mkdirs(target.getAbsoluteFile().getParentFile());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(target);
            if (data != null) {
                ((OutputStream)out).write(data.getBytes(StandardCharsets.UTF_8));
            }
            ((OutputStream)out).close();
            out = null;
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File target, InputStream source) throws IOException {
        this.mkdirs(target.getAbsoluteFile().getParentFile());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(target);
            this.copy(out, source, null);
            ((OutputStream)out).close();
            out = null;
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void copy(File source, File target) throws IOException {
        this.copy(source, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        long total = 0L;
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(source);
            this.mkdirs(target.getAbsoluteFile().getParentFile());
            out = new FileOutputStream(target);
            total = this.copy(out, in, listener);
            out.close();
            out = null;
            ((InputStream)in).close();
            in = null;
        }
        finally {
            block28: {
                block27: {
                    if (out == null) break block27;
                    out.close();
                }
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    break block28;
                }
                catch (IOException iOException) {}
                break block28;
                catch (IOException iOException) {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException iOException2) {}
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (IOException iOException3) {}
                        throw throwable;
                    }
                }
            }
        }
        return total;
    }

    private long copy(OutputStream os, InputStream is, FileProcessor.ProgressListener listener) throws IOException {
        int bytes;
        long total = 0L;
        byte[] buffer = new byte[32768];
        while ((bytes = is.read(buffer)) >= 0) {
            os.write(buffer, 0, bytes);
            total += (long)bytes;
            if (listener == null || bytes <= 0) continue;
            try {
                listener.progressed(ByteBuffer.wrap(buffer, 0, bytes));
            }
            catch (Exception exception) {}
        }
        return total;
    }

    public void move(File source, File target) throws IOException {
        if (!source.renameTo(target)) {
            this.copy(source, target);
            target.setLastModified(source.lastModified());
            source.delete();
        }
    }

    public String readChecksum(File checksumFile) throws IOException {
        return ChecksumUtils.read((File)checksumFile);
    }

    public void writeChecksum(File checksumFile, String checksum) throws IOException {
        this.write(checksumFile, checksum);
    }
}

