/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.core.env;

import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.naming.NameUtils;
import org.springframework.core.env.PropertyResolver;

public class PropertyResolverAdapter
implements PropertyResolver {
    private final io.micronaut.core.value.PropertyResolver propertyResolver;
    private final PropertyPlaceholderResolver placeholderResolver;

    public PropertyResolverAdapter(io.micronaut.core.value.PropertyResolver propertyResolver, PropertyPlaceholderResolver placeholderResolver) {
        this.propertyResolver = propertyResolver;
        this.placeholderResolver = placeholderResolver;
    }

    public io.micronaut.core.value.PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public boolean containsProperty(String key) {
        return this.propertyResolver.getProperty(NameUtils.hyphenate((String)key), String.class).isPresent();
    }

    public String getProperty(String key) {
        return this.propertyResolver.getProperty(NameUtils.hyphenate((String)key), String.class).orElse(null);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperty(NameUtils.hyphenate((String)key), String.class, null);
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        return this.getProperty(NameUtils.hyphenate((String)key), targetType, null);
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)this.propertyResolver.getProperty(NameUtils.hyphenate((String)key), targetType, defaultValue);
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.getRequiredProperty(NameUtils.hyphenate((String)key), String.class);
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        T v = this.getProperty(NameUtils.hyphenate((String)key), targetType, null);
        if (v == null) {
            throw new IllegalStateException("Property [" + key + "] not found");
        }
        return v;
    }

    public String resolvePlaceholders(String text) {
        return this.placeholderResolver.resolvePlaceholders(text).orElse(null);
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return (String)this.placeholderResolver.resolvePlaceholders(text).orElseThrow(() -> new IllegalArgumentException("Unable to resolve placeholders for property: " + text));
    }
}

