/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.internal;

import io.micronaut.core.annotation.Experimental;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;

public class InternalApiTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    private static final String IO_MICRONAUT = "io.micronaut";
    private boolean warned = false;

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!element.getName().startsWith(IO_MICRONAUT)) {
            this.warn((Element)element, context);
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        this.warnMember((MemberElement)element, context);
    }

    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        this.warnMember((MemberElement)element, context);
    }

    public void visitField(FieldElement element, VisitorContext context) {
        this.warnMember((MemberElement)element, context);
    }

    private void warnMember(MemberElement element, VisitorContext context) {
        if (!element.getDeclaringType().getName().startsWith(IO_MICRONAUT)) {
            this.warn((Element)element, context);
        }
    }

    private void warn(Element element, VisitorContext context) {
        if (element.hasAnnotation(Internal.class) || element.hasAnnotation(Experimental.class)) {
            this.warned = true;
            context.warn("Element extends or implements an internal or experimental Micronaut API", element);
        }
    }

    public void finish(VisitorContext visitorContext) {
        if (this.warned) {
            visitorContext.warn("Overriding an internal Micronaut API may result in breaking changes in minor or patch versions of the framework. Proceed with caution!", null);
        }
    }
}

