/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.MessageLite;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

@CheckReturnValue
public class LiteProtoSubject
extends Subject {
    private final FailureMetadata metadata;
    private final MessageLite actual;

    static Subject.Factory<LiteProtoSubject, MessageLite> liteProtos() {
        return LiteProtoSubjectFactory.INSTANCE;
    }

    protected LiteProtoSubject(FailureMetadata failureMetadata, @Nullable MessageLite messageLite) {
        super(failureMetadata, (Object)messageLite);
        this.metadata = failureMetadata;
        this.actual = messageLite;
    }

    static String getTrimmedToString(@Nullable MessageLite messageLite) {
        String objectToString;
        String subjectString = String.valueOf(messageLite);
        String trimmedSubjectString = subjectString.trim();
        if (trimmedSubjectString.startsWith("# ") && trimmedSubjectString.startsWith(objectToString = String.format("# %s@%s", messageLite.getClass().getName(), Integer.toHexString(messageLite.hashCode())))) {
            subjectString = trimmedSubjectString.replaceFirst(Pattern.quote(objectToString), "").trim();
        }
        return subjectString.isEmpty() ? "[empty proto]" : subjectString;
    }

    protected String actualCustomStringRepresentation() {
        return this.actualCustomStringRepresentationForProtoPackageMembersToCall();
    }

    final String actualCustomStringRepresentationForProtoPackageMembersToCall() {
        return LiteProtoSubject.getTrimmedToString(this.actual);
    }

    public void isEqualTo(@Nullable Object expected) {
        if (Objects.equal((Object)this.actual, (Object)expected)) {
            return;
        }
        if (this.actual == null || expected == null) {
            super.isEqualTo(expected);
        } else if (this.actual.getClass() != expected.getClass()) {
            this.failWithoutActual(Fact.simpleFact((String)Strings.lenientFormat((String)"Not true that (%s) proto is equal to the expected (%s) object. They are not of the same class.", (Object[])new Object[]{this.actual.getClass().getName(), expected.getClass().getName()})), new Fact[0]);
        } else {
            String theirString;
            String ourString = LiteProtoSubject.getTrimmedToString(this.actual);
            if (!ourString.equals(theirString = LiteProtoSubject.getTrimmedToString((MessageLite)expected))) {
                new LiteProtoAsStringSubject(this.metadata, ourString).isEqualTo(theirString);
            } else {
                super.isEqualTo(expected);
            }
        }
    }

    @Deprecated
    public void isEqualTo(MessageLite.Builder builder) {
        this.isEqualTo((Object)builder);
    }

    public void isNotEqualTo(@Nullable Object expected) {
        if (Objects.equal((Object)this.actual, (Object)expected)) {
            if (this.actual == null) {
                super.isNotEqualTo(expected);
            } else {
                this.failWithoutActual(Fact.simpleFact((String)Strings.lenientFormat((String)"Not true that protos are different. Both are (%s) <%s>.", (Object[])new Object[]{this.actual.getClass().getName(), LiteProtoSubject.getTrimmedToString(this.actual)})), new Fact[0]);
            }
        }
    }

    @Deprecated
    public void isNotEqualTo(MessageLite.Builder builder) {
        this.isNotEqualTo((Object)builder);
    }

    public void isEqualToDefaultInstance() {
        if (this.actual == null) {
            this.failWithoutActual(Fact.simpleFact((String)Strings.lenientFormat((String)"Not true that <%s> is a default proto instance. It is null.", (Object[])new Object[]{this.actualCustomStringRepresentationForProtoPackageMembersToCall()})), new Fact[0]);
        } else if (!this.actual.equals(this.actual.getDefaultInstanceForType())) {
            this.failWithoutActual(Fact.simpleFact((String)Strings.lenientFormat((String)"Not true that <%s> is a default proto instance. It has set values.", (Object[])new Object[]{this.actualCustomStringRepresentationForProtoPackageMembersToCall()})), new Fact[0]);
        }
    }

    public void isNotEqualToDefaultInstance() {
        if (this.actual != null && this.actual.equals(this.actual.getDefaultInstanceForType())) {
            this.failWithoutActual(Fact.simpleFact((String)Strings.lenientFormat((String)"Not true that (%s) <%s> is not a default proto instance. It has no set values.", (Object[])new Object[]{this.actual.getClass().getName(), this.actualCustomStringRepresentationForProtoPackageMembersToCall()})), new Fact[0]);
        }
    }

    public void hasAllRequiredFields() {
        if (!this.actual.isInitialized()) {
            this.failWithoutActual(Fact.simpleFact((String)"expected to have all required fields set"), new Fact[]{Fact.fact((String)"but was", (Object)this.actualCustomStringRepresentationForProtoPackageMembersToCall()), Fact.simpleFact((String)"(Lite runtime could not determine which fields were missing.)")});
        }
    }

    public IntegerSubject serializedSize() {
        return this.check("getSerializedSize()", new Object[0]).that(Integer.valueOf(this.actual.getSerializedSize()));
    }

    private static final class LiteProtoSubjectFactory
    implements Subject.Factory<LiteProtoSubject, MessageLite> {
        private static final LiteProtoSubjectFactory INSTANCE = new LiteProtoSubjectFactory();

        private LiteProtoSubjectFactory() {
        }

        public LiteProtoSubject createSubject(FailureMetadata failureMetadata, @Nullable MessageLite messageLite) {
            return new LiteProtoSubject(failureMetadata, messageLite);
        }
    }

    private static final class LiteProtoAsStringSubject
    extends Subject {
        LiteProtoAsStringSubject(FailureMetadata metadata, @Nullable String actual) {
            super(metadata, (Object)actual);
        }
    }
}

