/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Enclosing;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import java.io.Serializable;

@BugPattern(summary="Lock on the class other than the enclosing class of the code block can unintentionally prevent the locked class being used properly.", severity=BugPattern.SeverityLevel.WARNING)
public class LockOnNonEnclosingClassLiteral
extends BugChecker
implements BugChecker.SynchronizedTreeMatcher {
    public Description matchSynchronized(SynchronizedTree tree, VisitorState state) {
        ExpressionTree lock = ASTHelpers.stripParentheses((ExpressionTree)tree.getExpression());
        Enclosing.Class lockOnEnclosingClassMatcher = Matchers.enclosingClass((Matcher & Serializable)(t, s) -> ASTHelpers.getSymbol((ClassTree)t).equals(ASTHelpers.getSymbol((Tree)((MemberSelectTree)lock).getExpression())));
        if (LockOnNonEnclosingClassLiteral.isClassLiteral(lock) && !lockOnEnclosingClassMatcher.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean isClassLiteral(Tree tree) {
        if (tree.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        return ((MemberSelectTree)tree).getIdentifier().contentEquals("class");
    }
}

