/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractPatternSyntaxChecker;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.MethodInvocationTree;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@BugPattern(summary="Invalid syntax used for a regular expression", severity=BugPattern.SeverityLevel.ERROR)
public class InvalidPatternSyntax
extends AbstractPatternSyntaxChecker {
    private static final String MESSAGE_BASE = "Invalid syntax used for a regular expression: ";

    @Override
    protected final Description matchRegexLiteral(MethodInvocationTree tree, VisitorState state, String pattern, int flags) {
        try {
            Pattern.compile(pattern, flags);
            return Description.NO_MATCH;
        }
        catch (PatternSyntaxException e) {
            return this.buildDescription(tree).setMessage(MESSAGE_BASE + e.getMessage()).build();
        }
    }
}

