/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.analysis.filter.KotlinGeneratedFilter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class KotlinUnsafeCastOperatorFilter
implements IFilter {
    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (!KotlinGeneratedFilter.isKotlinClass(context)) {
            return;
        }
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i : methodNode.instructions) {
            matcher.match("kotlin/TypeCastException", i, output);
            matcher.match("java/lang/NullPointerException", i, output);
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(String exceptionType, AbstractInsnNode start, IFilterOutput output) {
            if (199 != start.getOpcode()) {
                return;
            }
            this.cursor = start;
            JumpInsnNode jumpInsnNode = (JumpInsnNode)this.cursor;
            AbstractInsnNode next = this.cursor.getNext();
            if (next != null && next.getOpcode() == 87) {
                this.next();
            }
            this.nextIsType(187, exceptionType);
            this.nextIs(89);
            this.nextIs(18);
            if (this.cursor == null) {
                return;
            }
            LdcInsnNode ldc = (LdcInsnNode)this.cursor;
            if (!(ldc.cst instanceof String) || !((String)ldc.cst).startsWith("null cannot be cast to non-null type")) {
                return;
            }
            this.nextIsInvoke(183, exceptionType, "<init>", "(Ljava/lang/String;)V");
            this.nextIs(191);
            if (this.cursor == null) {
                return;
            }
            if (this.cursor.getNext() != jumpInsnNode.label) {
                return;
            }
            output.ignore(start, this.cursor);
        }
    }
}

