/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.SerializationResult;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ObjectCodecs {
    private final ObjectCodecRegistry codecRegistry;
    private final SerializationContext serializationContext;
    private final DeserializationContext deserializationContext;

    public ObjectCodecs(ObjectCodecRegistry codecRegistry, ImmutableClassToInstanceMap<Object> dependencies) {
        this.codecRegistry = codecRegistry;
        this.serializationContext = new SerializationContext(codecRegistry, dependencies);
        this.deserializationContext = new DeserializationContext(codecRegistry, dependencies);
    }

    public ObjectCodecs(ObjectCodecRegistry codecRegistry) {
        this(codecRegistry, (ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
    }

    public ObjectCodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public DeserializationContext getDeserializationContext() {
        return this.deserializationContext;
    }

    public static SerializationResult<ByteString> serialize(Object subject, SerializationContext context) throws SerializationException {
        ByteString bytes = ObjectCodecs.serializeToByteString(subject, context);
        return SerializationResult.create(bytes, context.createFutureToBlockWritingOn());
    }

    public ByteString serialize(Object subject) throws SerializationException {
        return ObjectCodecs.serializeToByteString(subject, this.serializationContext);
    }

    public void serialize(Object subject, CodedOutputStream codedOut) throws SerializationException {
        ObjectCodecs.serializeImpl(subject, codedOut, this.serializationContext);
    }

    public ByteString serializeMemoized(Object subject) throws SerializationException {
        return ObjectCodecs.serializeToByteString(subject, this.serializationContext.getMemoizingContext());
    }

    public void serializeMemoized(Object subject, CodedOutputStream codedOut) throws SerializationException {
        ObjectCodecs.serializeImpl(subject, codedOut, this.serializationContext.getMemoizingContext());
    }

    public SerializationResult<ByteString> serializeMemoizedAndBlocking(Object subject) throws SerializationException {
        return ObjectCodecs.serialize(subject, this.serializationContext.getMemoizingAndBlockingOnWriteContext());
    }

    private static ByteString serializeToByteString(Object subject, SerializationContext context) throws SerializationException {
        ByteString.Output resultOut = ByteString.newOutput();
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)resultOut);
        ObjectCodecs.serializeImpl(subject, codedOut, context);
        try {
            codedOut.flush();
            return resultOut.toByteString();
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize " + String.valueOf(subject), e);
        }
    }

    private static void serializeImpl(Object subject, CodedOutputStream codedOut, SerializationContext context) throws SerializationException {
        try {
            context.serialize(subject, codedOut);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize " + String.valueOf(subject), e);
        }
    }

    public static Object deserialize(CodedInputStream codedIn, DeserializationContext context) throws SerializationException {
        Object result;
        codedIn.enableAliasing(true);
        try {
            result = context.deserialize(codedIn);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to deserialize data", e);
        }
        try {
            if (!codedIn.isAtEnd()) {
                throw new SerializationException("input stream not exhausted after deserializing " + String.valueOf(result));
            }
        }
        catch (IOException e) {
            throw new SerializationException("Error checking for end of stream with " + String.valueOf(result), e);
        }
        return result;
    }

    public Object deserialize(ByteString data) throws SerializationException {
        return this.deserialize(data.newCodedInput());
    }

    public Object deserialize(CodedInputStream codedIn) throws SerializationException {
        return ObjectCodecs.deserialize(codedIn, this.deserializationContext);
    }

    public Object deserializeMemoized(ByteString data) throws SerializationException {
        return this.deserializeMemoized(data.newCodedInput());
    }

    public Object deserializeMemoized(CodedInputStream codedIn) throws SerializationException {
        return ObjectCodecs.deserialize(codedIn, this.deserializationContext.getMemoizingContext());
    }
}

