/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.RenamedDataEntry;

public class PrefixStrippingDataEntryReader
implements DataEntryReader {
    private final String prefix;
    private final DataEntryReader dataEntryReader;

    public PrefixStrippingDataEntryReader(String prefix, DataEntryReader dataEntryReader) {
        this.prefix = prefix;
        this.dataEntryReader = dataEntryReader;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        String name = dataEntry.getName();
        if (name.startsWith(this.prefix)) {
            dataEntry = new RenamedDataEntry(dataEntry, name.substring(this.prefix.length()));
        }
        this.dataEntryReader.read(dataEntry);
    }
}

