/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ClassField;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.ResourceUsageModel;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.CompilationUnit;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.ImportDeclaration;
import lombok.ast.Node;
import lombok.ast.VariableReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnusedResourceDetector
extends ResourceXmlDetector
implements Detector.JavaScanner,
Detector.BinaryResourceScanner,
Detector.XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(UnusedResourceDetector.class, EnumSet.of(Scope.MANIFEST, Scope.ALL_RESOURCE_FILES, Scope.ALL_JAVA_FILES, Scope.BINARY_RESOURCE_FILE, Scope.TEST_SOURCES));
    public static final Issue ISSUE = Issue.create((String)"UnusedResources", (String)"Unused resources", (String)"Unused resources make applications larger and slow down builds.", (Category)Category.PERFORMANCE, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue ISSUE_IDS = Issue.create((String)"UnusedIds", (String)"Unused id", (String)"This resource id definition appears not to be needed since it is not referenced from anywhere. Having id definitions, even if unused, is not necessarily a bad idea since they make working on layouts and menus easier, so there is not a strong reason to delete these.", (Category)Category.PERFORMANCE, (int)1, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);
    private final UnusedResourceDetectorUsageModel mModel = new UnusedResourceDetectorUsageModel();
    public static boolean sIncludeInactiveReferences = true;

    private void addDynamicResources(Context context) {
        Project project = context.getProject();
        AndroidProject model = project.getGradleProjectModel();
        if (model != null) {
            Variant selectedVariant = project.getCurrentVariant();
            if (selectedVariant != null) {
                for (BuildTypeContainer container : model.getBuildTypes()) {
                    if (!selectedVariant.getBuildType().equals(container.getBuildType().getName())) continue;
                    this.addDynamicResources(project, container.getBuildType().getResValues());
                }
            }
            ProductFlavor flavor = model.getDefaultConfig().getProductFlavor();
            this.addDynamicResources(project, flavor.getResValues());
        }
    }

    private void addDynamicResources(Project project, Map<String, ClassField> resValues) {
        Set<String> keys = resValues.keySet();
        if (!keys.isEmpty()) {
            Location location = LintUtils.guessGradleLocation((Project)project);
            for (String name : keys) {
                ClassField field = resValues.get(name);
                ResourceType type = ResourceType.getEnum((String)field.getType());
                if (type == null) continue;
                ResourceUsageModel.Resource resource = this.mModel.declareResource(type, name, null);
                resource.recordLocation(location);
            }
        }
    }

    public void afterCheckProject(Context context) {
        if (context.getPhase() == 1) {
            Project project = context.getProject();
            if (sIncludeInactiveReferences && project.isGradleProject() && !project.isLibrary()) {
                AndroidProject model = project.getGradleProjectModel();
                Variant variant = project.getCurrentVariant();
                if (model != null && variant != null) {
                    this.addInactiveReferences(model, variant);
                }
            }
            this.addDynamicResources(context);
            this.mModel.processToolsAttributes();
            List<ResourceUsageModel.Resource> unusedResources = this.mModel.findUnused();
            HashSet unused = Sets.newHashSetWithExpectedSize((int)unusedResources.size());
            for (ResourceUsageModel.Resource resource : unusedResources) {
                if (!resource.isDeclared() || resource.isPublic() || resource.type == ResourceType.PUBLIC) continue;
                unused.add(resource);
            }
            if (!unused.isEmpty() && !context.isEnabled(ISSUE_IDS)) {
                ArrayList ids = Lists.newArrayList();
                for (ResourceUsageModel.Resource resource : unused) {
                    if (resource.type != ResourceType.ID) continue;
                    ids.add(resource);
                }
                unused.removeAll(ids);
            }
            if (!unused.isEmpty() && !context.getDriver().hasParserErrors()) {
                this.mModel.unused = unused;
                context.requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else {
            assert (context.getPhase() == 2);
            Collection<ResourceUsageModel.Resource> unused = this.mModel.unused;
            if (!unused.isEmpty()) {
                if ((unused = this.mModel.findUnused(Lists.newArrayList(unused))).isEmpty()) {
                    return;
                }
                for (ResourceUsageModel.Resource resource : unused) {
                    ResourceType type;
                    Location location = resource.locations;
                    if (location != null || (type = resource.type) == null || !LintUtils.isFileBasedResourceType((ResourceType)type)) continue;
                    String name = resource.name;
                    ArrayList folders = Lists.newArrayList();
                    List resourceFolders = context.getProject().getResourceFolders();
                    for (File res : resourceFolders) {
                        File[] f = res.listFiles();
                        if (f == null) continue;
                        folders.addAll(Arrays.asList(f));
                    }
                    if (folders.isEmpty()) continue;
                    Collections.sort(folders, new Comparator<File>(){

                        @Override
                        public int compare(File file1, File file2) {
                            return file1.getName().compareTo(file2.getName());
                        }
                    });
                    for (File folder : folders) {
                        Object[] files;
                        if (!folder.getName().startsWith(type.getName()) || (files = folder.listFiles()) == null) continue;
                        Arrays.sort(files);
                        for (Object file : files) {
                            String fileName = ((File)file).getName();
                            if (!fileName.startsWith(name) || !fileName.startsWith(".", name.length())) continue;
                            resource.recordLocation(Location.create((File)file));
                        }
                    }
                }
                ArrayList sorted = Lists.newArrayList(unused);
                Collections.sort(sorted);
                Boolean skippedLibraries = null;
                for (ResourceUsageModel.Resource resource : sorted) {
                    Location location = resource.locations;
                    if (location != null) {
                        location = Location.reverse((Location)location);
                    }
                    if (location == null) {
                        if (skippedLibraries == null) {
                            skippedLibraries = false;
                            for (Project project : context.getDriver().getProjects()) {
                                if (project.getReportIssues()) continue;
                                skippedLibraries = true;
                                break;
                            }
                        }
                        if (skippedLibraries.booleanValue()) continue;
                    }
                    String message = String.format("The resource `%1$s` appears to be unused", resource.getField());
                    context.report(UnusedResourceDetector.getIssue(resource), location, message);
                }
            }
        }
    }

    private static List<SourceProvider> getInactiveSourceProviders(AndroidProject project, Variant variant) {
        Collection variants = project.getVariants();
        ArrayList providers = Lists.newArrayList();
        Collection flavors = project.getProductFlavors();
        for (ProductFlavorContainer pfc : flavors) {
            if (variant.getProductFlavors().contains(pfc.getProductFlavor().getName())) continue;
            providers.add(pfc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider;
            if (variant.getName().equals(v.getName()) || (provider = v.getMainArtifact().getMultiFlavorSourceProvider()) == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = project.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            if (variant.getBuildType().equals(btc.getBuildType().getName())) continue;
            providers.add(btc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider;
            if (variant.getName().equals(v.getName()) || (provider = v.getMainArtifact().getVariantSourceProvider()) == null) continue;
            providers.add(provider);
        }
        return providers;
    }

    private void recordInactiveJavaReferences(File resDir) {
        File[] files = resDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.recordInactiveJavaReferences(file);
                    continue;
                }
                if (!file.getName().endsWith(".java")) continue;
                try {
                    String java = Files.toString((File)file, (Charset)Charsets.UTF_8);
                    this.mModel.tokenizeJavaCode(java);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
    }

    private void recordInactiveXmlResources(File resDir) {
        File[] resourceFolders = resDir.listFiles();
        if (resourceFolders != null) {
            for (File folder : resourceFolders) {
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folder.getName());
                if (folderType == null) continue;
                this.recordInactiveXmlResources(folderType, folder);
            }
        }
    }

    private void recordInactiveXmlResources(ResourceFolderType folderType, File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                String path = file.getPath();
                boolean isXml = SdkUtils.endsWithIgnoreCase((String)path, (String)".xml");
                try {
                    if (isXml) {
                        String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
                        this.mModel.visitXmlDocument(file, folderType, document);
                        continue;
                    }
                    this.mModel.visitBinaryResource(folderType, file);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
    }

    private void addInactiveReferences(AndroidProject model, Variant variant) {
        for (SourceProvider provider : UnusedResourceDetector.getInactiveSourceProviders(model, variant)) {
            for (File res : provider.getResDirectories()) {
                if (!res.isDirectory()) continue;
                this.recordInactiveXmlResources(res);
            }
            for (File file : provider.getJavaDirectories()) {
                if (!file.isDirectory()) continue;
                this.recordInactiveJavaReferences(file);
            }
        }
    }

    public static String getUnusedResource(String errorMessage, TextFormat format) {
        errorMessage = format.toText(errorMessage);
        return LintUtils.findSubstring((String)errorMessage, (String)"The resource ", (String)" appears ");
    }

    private static Issue getIssue(ResourceUsageModel.Resource resource) {
        return resource.type != ResourceType.ID ? ISSUE : ISSUE_IDS;
    }

    public boolean appliesTo(ResourceFolderType folderType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBinaryResource(ResourceContext context) {
        this.mModel.context = context;
        try {
            this.mModel.visitBinaryResource(context.getResourceFolderType(), context.file);
        }
        finally {
            this.mModel.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitDocument(XmlContext context, Document document) {
        this.mModel.xmlContext = context;
        this.mModel.context = this.mModel.xmlContext;
        try {
            this.mModel.visitXmlDocument(context.file, context.getResourceFolderType(), document);
        }
        finally {
            this.mModel.xmlContext = null;
            this.mModel.context = null;
        }
    }

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Arrays.asList(ClassDeclaration.class, ImportDeclaration.class);
    }

    public boolean appliesToResourceRefs() {
        return true;
    }

    public void visitResourceReference(JavaContext context, AstVisitor visitor, Node node, String type, String name, boolean isFramework) {
        if (!isFramework) {
            ResourceType t = ResourceType.getEnum((String)type);
            assert (t != null) : type;
            ResourceUsageModel.markReachable(this.mModel.addResource(t, name, null));
        }
    }

    public AstVisitor createJavaVisitor(JavaContext context) {
        if (context.getDriver().getPhase() == 1) {
            return new UnusedResourceVisitor(context);
        }
        return null;
    }

    private static class UnusedResourceDetectorUsageModel
    extends ResourceUsageModel {
        public XmlContext xmlContext;
        public Context context;
        public Set<ResourceUsageModel.Resource> unused = Sets.newHashSet();

        private UnusedResourceDetectorUsageModel() {
        }

        @Override
        protected String readText(File file) {
            if (this.context != null) {
                return this.context.getClient().readFile(file);
            }
            try {
                return Files.toString((File)file, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                return "";
            }
        }

        @Override
        protected ResourceUsageModel.Resource declareResource(ResourceType type, String name, org.w3c.dom.Node node) {
            ResourceUsageModel.Resource resource = super.declareResource(type, name, node);
            if (this.context != null) {
                resource.setDeclared(this.context.getProject().getReportIssues());
                if (this.context.getPhase() == 2 && this.unused.contains(resource)) {
                    if (this.xmlContext != null && this.xmlContext.getDriver().isSuppressed(this.xmlContext, UnusedResourceDetector.getIssue(resource), node)) {
                        resource.setKeep(true);
                    } else if (node == null || this.xmlContext == null) {
                        resource.recordLocation(Location.create((File)this.context.file));
                    } else {
                        Attr attribute;
                        if (node instanceof Element && (attribute = ((Element)node).getAttributeNode("name")) != null) {
                            node = attribute;
                        }
                        resource.recordLocation(this.xmlContext.getLocation(node));
                    }
                }
            }
            return resource;
        }
    }

    private class UnusedResourceVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;
        private boolean mScannedForStaticImports;

        public UnusedResourceVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitClassDeclaration(ClassDeclaration node) {
            String description = node.astName().astValue();
            return description.equals("R");
        }

        public boolean visitImportDeclaration(ImportDeclaration node) {
            block3: {
                String last;
                block4: {
                    if (!node.astStaticImport()) break block4;
                    Iterator iterator = node.astParts().iterator();
                    while (iterator.hasNext()) {
                        String typeString;
                        ResourceType type;
                        String identifier = ((Identifier)iterator.next()).astValue();
                        if (!identifier.equals("R")) continue;
                        if (!iterator.hasNext() || (type = ResourceType.getEnum((String)(typeString = ((Identifier)iterator.next()).astValue()))) == null) break block3;
                        if (iterator.hasNext()) {
                            String name = ((Identifier)iterator.next()).astValue();
                            ResourceUsageModel.Resource resource = UnusedResourceDetector.this.mModel.addResource(type, name, null);
                            ResourceUsageModel.markReachable(resource);
                            break block3;
                        }
                        if (this.mScannedForStaticImports) break block3;
                        this.mScannedForStaticImports = true;
                        CompilationUnit unit = node.upToCompilationUnit();
                        this.scanForStaticImportReferences(unit);
                        break block3;
                    }
                    break block3;
                }
                if (this.mScannedForStaticImports || !Character.isLowerCase((last = ((Identifier)node.astParts().last()).astValue()).charAt(0))) break block3;
                Iterator iterator = node.astParts().iterator();
                while (iterator.hasNext()) {
                    String typeString;
                    ResourceType type;
                    String identifier = ((Identifier)iterator.next()).astValue();
                    if (!identifier.equals("R")) continue;
                    if (!iterator.hasNext() || (type = ResourceType.getEnum((String)(typeString = ((Identifier)iterator.next()).astValue()))) == null || iterator.hasNext()) break;
                    this.mScannedForStaticImports = true;
                    CompilationUnit unit = node.upToCompilationUnit();
                    this.scanForStaticImportReferences(unit);
                    break;
                }
            }
            return false;
        }

        private void scanForStaticImportReferences(CompilationUnit unit) {
            if (unit == null) {
                return;
            }
            unit.accept((AstVisitor)new ForwardingAstVisitor(){

                public boolean visitVariableReference(VariableReference node) {
                    ResourceType type;
                    JavaParser.ResolvedClass rClass;
                    JavaParser.ResolvedField field;
                    JavaParser.ResolvedClass typeClass;
                    JavaParser.ResolvedNode resolved = UnusedResourceVisitor.this.mContext.resolve((Node)node);
                    if (resolved instanceof JavaParser.ResolvedField && (typeClass = (field = (JavaParser.ResolvedField)resolved).getContainingClass()) != null && (rClass = typeClass.getContainingClass()) != null && "R".equals(rClass.getSimpleName()) && (type = ResourceType.getEnum((String)typeClass.getSimpleName())) != null) {
                        ResourceUsageModel.Resource resource = UnusedResourceDetector.this.mModel.addResource(type, field.getName(), null);
                        ResourceUsageModel.markReachable(resource);
                    }
                    return super.visitVariableReference(node);
                }
            });
        }
    }
}

