/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import javax.inject.Inject;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Avoid naming of classes and methods that is similar to contextual keywords.  When invoking such a method, qualify it.")
public final class NamedLikeContextualKeyword
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> DISALLOWED_CLASS_NAMES = ImmutableSet.of((Object)"exports", (Object)"opens", (Object)"requires", (Object)"uses", (Object)"module", (Object)"permits", (Object[])new String[]{"sealed", "var", "provides", "to", "with", "open", "record", "transitive", "yield"});
    private static final Matcher<MethodTree> DISALLOWED_METHOD_NAME_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.methodIsConstructor()), Matchers.methodIsNamed((String)"yield")});
    private final boolean enableMethodNames;
    private final boolean enableClassNames;

    @Inject
    NamedLikeContextualKeyword(ErrorProneFlags flags) {
        this.enableMethodNames = flags.getBoolean("NamedLikeContextualKeyword:EnableMethodNames").orElse(false);
        this.enableClassNames = flags.getBoolean("NamedLikeContextualKeyword:EnableClassNames").orElse(false);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!this.enableMethodNames) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (!ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes()).findAny().isPresent() && DISALLOWED_METHOD_NAME_MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!this.enableClassNames) {
            return Description.NO_MATCH;
        }
        if (DISALLOWED_CLASS_NAMES.contains((Object)tree.getSimpleName().toString())) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree select = tree.getMethodSelect();
        if (!(select instanceof IdentifierTree)) {
            return Description.NO_MATCH;
        }
        if (!((IdentifierTree)select).getName().contentEquals("yield")) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String qualifier = NamedLikeContextualKeyword.getQualifier(state, ASTHelpers.getSymbol((MethodInvocationTree)tree), fix);
        return this.describeMatch(tree, (Fix)fix.prefixWith((Tree)select, qualifier + ".").build());
    }

    private static String getQualifier(VisitorState state, Symbol.MethodSymbol sym, SuggestedFix.Builder fix) {
        Symbol.ClassSymbol enclosingClass;
        if (sym.isStatic()) {
            return SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (Symbol)sym.owner.enclClass());
        }
        TreePath path = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)state.getPath(), ClassTree.class);
        if (sym.isMemberOf(ASTHelpers.getSymbol((ClassTree)((ClassTree)path.getLeaf())), state.getTypes())) {
            return "this";
        }
        while (!sym.isMemberOf(enclosingClass = ASTHelpers.getSymbol((ClassTree)((ClassTree)(path = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)path, ClassTree.class)).getLeaf())), state.getTypes())) {
        }
        return SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (Symbol)enclosingClass) + ".this";
    }
}

