/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Module
implements Comparable<Module> {
    private String name;
    private String dirname;
    private Map<String, Package> packages = new HashMap<String, Package>();
    private Map<String, Source> sources = new HashMap<String, Source>();
    private Map<String, File> artifacts = new HashMap<String, File>();

    public Module(String n, String dn) {
        this.name = n;
        this.dirname = n;
    }

    public String name() {
        return this.name;
    }

    public String dirname() {
        return this.dirname;
    }

    public Map<String, Package> packages() {
        return this.packages;
    }

    public Map<String, Source> sources() {
        return this.sources;
    }

    public Map<String, File> artifacts() {
        return this.artifacts;
    }

    public boolean equals(Object o) {
        return o instanceof Module && this.name.equals(((Module)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Module o) {
        return this.name.compareTo(o.name);
    }

    public void save(StringBuilder b) {
        b.append("M ").append(this.name).append(":").append("\n");
        Package.savePackages(this.packages, b);
    }

    public static Module load(String l) {
        int cp = l.indexOf(58, 2);
        if (cp == -1) {
            return null;
        }
        String name = l.substring(2, cp);
        return new Module(name, "");
    }

    public static void saveModules(Map<String, Module> ms, StringBuilder b) {
        for (Module m : ms.values()) {
            m.save(b);
        }
    }

    public void addPackage(Package p) {
        this.packages.put(p.name(), p);
    }

    public Package lookupPackage(String pkg) {
        Package p = this.packages.get(pkg);
        if (p == null) {
            p = new Package(this, pkg);
            this.packages.put(pkg, p);
        }
        return p;
    }

    public void addSource(String pkg, Source src) {
        Package p = this.lookupPackage(pkg);
        src.setPackage(p);
        p.addSource(src);
        this.sources.put(src.file().getPath(), src);
    }

    public Source lookupSource(String path) {
        return this.sources.get(path);
    }

    public void addArtifacts(String pkg, Set<URI> as) {
        Package p = this.lookupPackage(pkg);
        for (URI u : as) {
            p.addArtifact(new File(u));
        }
    }

    public void setDependencies(String pkg, Map<String, Set<String>> deps, boolean cp) {
        this.lookupPackage(pkg).setDependencies(deps, cp);
    }

    public void setPubapi(String pkg, PubApi ps) {
        Package p = this.lookupPackage(pkg);
        p.setPubapi(ps);
    }

    public boolean hasPubapiChanged(String pkg, PubApi newPubApi) {
        Package p = this.lookupPackage(pkg);
        return p.hasPubApiChanged(newPubApi);
    }
}

