/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.Binder;
import javax.xml.bind.ContextFinder;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import org.w3c.dom.Node;

public abstract class JAXBContext {
    public static final String JAXB_CONTEXT_FACTORY = "javax.xml.bind.JAXBContextFactory";

    protected JAXBContext() {
    }

    public static JAXBContext newInstance(String string) throws JAXBException {
        return JAXBContext.newInstance(string, JAXBContext.getContextClassLoader());
    }

    public static JAXBContext newInstance(String string, ClassLoader classLoader) throws JAXBException {
        return JAXBContext.newInstance(string, classLoader, Collections.emptyMap());
    }

    public static JAXBContext newInstance(String string, ClassLoader classLoader, Map<String, ?> map) throws JAXBException {
        return ContextFinder.find(JAXB_CONTEXT_FACTORY, string, classLoader, map);
    }

    public static JAXBContext newInstance(Class<?> ... classArray) throws JAXBException {
        return JAXBContext.newInstance(classArray, Collections.emptyMap());
    }

    public static JAXBContext newInstance(Class<?>[] classArray, Map<String, ?> map) throws JAXBException {
        if (classArray == null) {
            throw new IllegalArgumentException();
        }
        for (int i = classArray.length - 1; i >= 0; --i) {
            if (classArray[i] != null) continue;
            throw new IllegalArgumentException();
        }
        return ContextFinder.find(classArray, map);
    }

    public abstract Unmarshaller createUnmarshaller() throws JAXBException;

    public abstract Marshaller createMarshaller() throws JAXBException;

    @Deprecated
    public abstract Validator createValidator() throws JAXBException;

    public <T> Binder<T> createBinder(Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    public Binder<Node> createBinder() {
        return this.createBinder(Node.class);
    }

    public JAXBIntrospector createJAXBIntrospector() {
        throw new UnsupportedOperationException();
    }

    public void generateSchema(SchemaOutputResolver schemaOutputResolver) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

