/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.tree;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Pretty
implements Tree.Visitor<Void, Void> {
    private final StringBuilder sb = new StringBuilder();
    int indent = 0;
    boolean newLine = false;

    static String pretty(Tree tree) {
        Pretty pretty = new Pretty();
        tree.accept(pretty, null);
        return pretty.sb.toString();
    }

    void printLine() {
        this.append('\n');
        this.newLine = true;
    }

    void printLine(String line) {
        if (!this.newLine) {
            this.append('\n');
        }
        this.append(line).append('\n');
        this.newLine = true;
    }

    Pretty append(char c) {
        if (c == '\n') {
            this.newLine = true;
        } else if (this.newLine) {
            this.sb.append(Strings.repeat((String)" ", (int)(this.indent * 2)));
            this.newLine = false;
        }
        this.sb.append(c);
        return this;
    }

    Pretty append(String s) {
        if (this.newLine) {
            this.sb.append(Strings.repeat((String)" ", (int)(this.indent * 2)));
            this.newLine = false;
        }
        this.sb.append(s);
        return this;
    }

    @Override
    public Void visitIdent(Tree.Ident ident, Void input) {
        this.sb.append(ident.value());
        return null;
    }

    @Override
    public Void visitWildTy(Tree.WildTy wildTy, Void input) {
        this.printAnnos(wildTy.annos());
        this.append('?');
        if (wildTy.lower().isPresent()) {
            this.append(" super ");
            wildTy.lower().get().accept(this, null);
        }
        if (wildTy.upper().isPresent()) {
            this.append(" extends ");
            wildTy.upper().get().accept(this, null);
        }
        return null;
    }

    @Override
    public Void visitArrTy(Tree.ArrTy arrTy, Void input) {
        arrTy.elem().accept(this, null);
        if (!arrTy.annos().isEmpty()) {
            this.append(' ');
            this.printAnnos(arrTy.annos());
        }
        this.append("[]");
        return null;
    }

    @Override
    public Void visitPrimTy(Tree.PrimTy primTy, Void input) {
        this.append(primTy.tykind().toString());
        return null;
    }

    @Override
    public Void visitVoidTy(Tree.VoidTy primTy, Void input) {
        this.append("void");
        return null;
    }

    @Override
    public Void visitClassTy(Tree.ClassTy classTy, Void input) {
        if (classTy.base().isPresent()) {
            classTy.base().get().accept(this, null);
            this.append('.');
        }
        this.printAnnos(classTy.annos());
        this.append(classTy.name().value());
        if (!classTy.tyargs().isEmpty()) {
            this.append('<');
            boolean first = true;
            for (Tree t : classTy.tyargs()) {
                if (!first) {
                    this.append(", ");
                }
                t.accept(this, null);
                first = false;
            }
            this.append('>');
        }
        return null;
    }

    @Override
    public Void visitLiteral(Tree.Literal literal, Void input) {
        this.append(literal.value().toString());
        return null;
    }

    @Override
    public Void visitTypeCast(Tree.TypeCast typeCast, Void input) {
        this.append('(');
        typeCast.ty().accept(this, null);
        this.append(") ");
        typeCast.expr().accept(this, null);
        return null;
    }

    @Override
    public Void visitUnary(Tree.Unary unary, Void input) {
        switch (unary.op()) {
            case POST_INCR: 
            case POST_DECR: {
                unary.expr().accept(this, null);
                this.append(unary.op().toString());
                break;
            }
            case PRE_INCR: 
            case PRE_DECR: 
            case UNARY_PLUS: 
            case NEG: 
            case NOT: 
            case BITWISE_COMP: {
                this.append(unary.op().toString());
                unary.expr().accept(this, null);
                break;
            }
            default: {
                throw new AssertionError((Object)unary.op().name());
            }
        }
        return null;
    }

    @Override
    public Void visitBinary(Tree.Binary binary, Void input) {
        this.append('(');
        binary.lhs().accept(this, null);
        this.append(" " + (Object)((Object)binary.op()) + " ");
        binary.rhs().accept(this, null);
        this.append(')');
        return null;
    }

    @Override
    public Void visitConstVarName(Tree.ConstVarName constVarName, Void input) {
        this.append(Joiner.on((char)'.').join(constVarName.name()));
        return null;
    }

    @Override
    public Void visitClassLiteral(Tree.ClassLiteral classLiteral, Void input) {
        classLiteral.accept(this, input);
        this.append(".class");
        return null;
    }

    @Override
    public Void visitAssign(Tree.Assign assign, Void input) {
        this.append(assign.name().value()).append(" = ");
        assign.expr().accept(this, null);
        return null;
    }

    @Override
    public Void visitConditional(Tree.Conditional conditional, Void input) {
        this.append("(");
        conditional.cond().accept(this, null);
        this.append(" ? ");
        conditional.iftrue().accept(this, null);
        this.append(" : ");
        conditional.iffalse().accept(this, null);
        this.append(")");
        return null;
    }

    @Override
    public Void visitArrayInit(Tree.ArrayInit arrayInit, Void input) {
        this.append('{');
        boolean first = true;
        for (Tree.Expression e : arrayInit.exprs()) {
            if (!first) {
                this.append(", ");
            }
            e.accept(this, null);
            first = false;
        }
        this.append('}');
        return null;
    }

    @Override
    public Void visitCompUnit(Tree.CompUnit compUnit, Void input) {
        if (compUnit.pkg().isPresent()) {
            compUnit.pkg().get().accept(this, null);
            this.printLine();
        }
        for (Tree.ImportDecl i : compUnit.imports()) {
            i.accept(this, null);
        }
        if (compUnit.mod().isPresent()) {
            this.printLine();
            compUnit.mod().get().accept(this, null);
        }
        for (Tree.TyDecl decl : compUnit.decls()) {
            this.printLine();
            decl.accept(this, null);
        }
        return null;
    }

    @Override
    public Void visitImportDecl(Tree.ImportDecl importDecl, Void input) {
        this.append("import ");
        if (importDecl.stat()) {
            this.append("static ");
        }
        this.append(Joiner.on((char)'.').join(importDecl.type()));
        if (importDecl.wild()) {
            this.append(".*");
        }
        this.append(";").append('\n');
        return null;
    }

    @Override
    public Void visitVarDecl(Tree.VarDecl varDecl, Void input) {
        this.printVarDecl(varDecl);
        this.append(';');
        return null;
    }

    private void printVarDecl(Tree.VarDecl varDecl) {
        this.printAnnos(varDecl.annos());
        this.printModifiers(varDecl.mods());
        varDecl.ty().accept(this, null);
        this.append(' ').append(varDecl.name().value());
        if (varDecl.init().isPresent()) {
            this.append(" = ");
            varDecl.init().get().accept(this, null);
        }
    }

    private void printAnnos(ImmutableList<Tree.Anno> annos) {
        for (Tree.Anno anno : annos) {
            anno.accept(this, null);
            this.append(' ');
        }
    }

    @Override
    public Void visitMethDecl(Tree.MethDecl methDecl, Void input) {
        for (Tree.Anno anno : methDecl.annos()) {
            anno.accept(this, null);
            this.printLine();
        }
        this.printModifiers(methDecl.mods());
        if (!methDecl.typarams().isEmpty()) {
            this.append('<');
            boolean first = true;
            for (Tree.TyParam t : methDecl.typarams()) {
                if (!first) {
                    this.append(", ");
                }
                t.accept(this, null);
                first = false;
            }
            this.append('>');
            this.append(' ');
        }
        if (methDecl.ret().isPresent()) {
            methDecl.ret().get().accept(this, null);
            this.append(' ');
        }
        this.append(methDecl.name().value());
        this.append('(');
        boolean first = true;
        for (Tree.VarDecl param : methDecl.params()) {
            if (!first) {
                this.append(", ");
            }
            this.printVarDecl(param);
            first = false;
        }
        this.append(')');
        if (!methDecl.exntys().isEmpty()) {
            this.append(" throws ");
            first = true;
            for (Tree.Type e : methDecl.exntys()) {
                if (!first) {
                    this.append(", ");
                }
                e.accept(this, null);
                first = false;
            }
        }
        if (methDecl.defaultValue().isPresent()) {
            this.append(" default ");
            methDecl.defaultValue().get().accept(this, null);
            this.append(";");
        } else if (methDecl.mods().contains((Object)TurbineModifier.ABSTRACT) || methDecl.mods().contains((Object)TurbineModifier.NATIVE)) {
            this.append(";");
        } else {
            this.append(" {}");
        }
        return null;
    }

    @Override
    public Void visitAnno(Tree.Anno anno, Void input) {
        this.append('@');
        this.append(Joiner.on((char)'.').join(anno.name()));
        if (!anno.args().isEmpty()) {
            this.append('(');
            boolean first = true;
            for (Tree.Expression e : anno.args()) {
                if (!first) {
                    this.append(", ");
                }
                e.accept(this, null);
                first = false;
            }
            this.append(')');
        }
        return null;
    }

    @Override
    public Void visitTyDecl(Tree.TyDecl tyDecl, Void input) {
        for (Tree.Anno anno : tyDecl.annos()) {
            anno.accept(this, null);
            this.printLine();
        }
        this.printModifiers(tyDecl.mods());
        switch (tyDecl.tykind()) {
            case CLASS: {
                this.append("class");
                break;
            }
            case INTERFACE: {
                this.append("interface");
                break;
            }
            case ENUM: {
                this.append("enum");
                break;
            }
            case ANNOTATION: {
                this.append("@interface");
            }
        }
        this.append(' ').append(tyDecl.name().value());
        if (!tyDecl.typarams().isEmpty()) {
            this.append('<');
            boolean first = true;
            for (Object t : tyDecl.typarams()) {
                if (!first) {
                    this.append(", ");
                }
                ((Tree.TyParam)t).accept(this, null);
                first = false;
            }
            this.append('>');
        }
        if (tyDecl.xtnds().isPresent()) {
            this.append(" extends ");
            tyDecl.xtnds().get().accept(this, null);
        }
        if (!tyDecl.impls().isEmpty()) {
            this.append(" implements ");
            boolean first = true;
            for (Object t : tyDecl.impls()) {
                if (!first) {
                    this.append(", ");
                }
                ((Tree.ClassTy)t).accept(this, null);
                first = false;
            }
        }
        this.append(" {").append('\n');
        ++this.indent;
        switch (tyDecl.tykind()) {
            case ENUM: {
                ArrayList<Object> nonConsts = new ArrayList<Object>();
                for (Object t : tyDecl.members()) {
                    Tree.VarDecl decl;
                    if (t instanceof Tree.VarDecl && (decl = (Tree.VarDecl)t).mods().contains((Object)TurbineModifier.ACC_ENUM)) {
                        this.append(decl.name().value()).append(',').append('\n');
                        continue;
                    }
                    nonConsts.add(t);
                }
                this.printLine(";");
                boolean first = true;
                for (Tree t : nonConsts) {
                    if (!first) {
                        this.printLine();
                    }
                    t.accept(this, null);
                    first = false;
                }
                break;
            }
            default: {
                boolean first = true;
                for (Object t : tyDecl.members()) {
                    if (!first) {
                        this.printLine();
                    }
                    ((Tree)t).accept(this, null);
                    first = false;
                }
            }
        }
        --this.indent;
        this.printLine("}");
        return null;
    }

    private void printModifiers(ImmutableSet<TurbineModifier> mods) {
        ArrayList<TurbineModifier> modifiers = new ArrayList<TurbineModifier>((Collection<TurbineModifier>)mods);
        Collections.sort(modifiers);
        for (TurbineModifier mod : modifiers) {
            switch (mod) {
                case PRIVATE: 
                case PROTECTED: 
                case PUBLIC: 
                case ABSTRACT: 
                case FINAL: 
                case STATIC: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case NATIVE: 
                case TRANSIENT: 
                case DEFAULT: 
                case TRANSITIVE: {
                    this.append(mod.toString()).append(' ');
                    break;
                }
            }
        }
    }

    @Override
    public Void visitTyParam(Tree.TyParam tyParam, Void input) {
        this.printAnnos(tyParam.annos());
        this.append(tyParam.name().value());
        if (!tyParam.bounds().isEmpty()) {
            this.append(" extends ");
            boolean first = true;
            for (Tree bound : tyParam.bounds()) {
                if (!first) {
                    this.append(" & ");
                }
                bound.accept(this, null);
                first = false;
            }
        }
        return null;
    }

    @Override
    public Void visitPkgDecl(Tree.PkgDecl pkgDecl, Void input) {
        for (Tree.Anno anno : pkgDecl.annos()) {
            anno.accept(this, null);
            this.printLine();
        }
        this.append("package ").append(Joiner.on((char)'.').join(pkgDecl.name())).append(';');
        return null;
    }

    @Override
    public Void visitModDecl(Tree.ModDecl modDecl, Void input) {
        for (Tree.Anno anno : modDecl.annos()) {
            anno.accept(this, null);
            this.printLine();
        }
        if (modDecl.open()) {
            this.append("open ");
        }
        this.append("module ").append(modDecl.moduleName()).append(" {");
        ++this.indent;
        this.append('\n');
        for (Tree.ModDirective directive : modDecl.directives()) {
            directive.accept(this, null);
        }
        --this.indent;
        this.append("}\n");
        return null;
    }

    @Override
    public Void visitModRequires(Tree.ModRequires modRequires, Void input) {
        this.append("requires ");
        this.printModifiers(modRequires.mods());
        this.append(modRequires.moduleName());
        this.append(";");
        this.append('\n');
        return null;
    }

    @Override
    public Void visitModExports(Tree.ModExports modExports, Void input) {
        this.append("exports ");
        this.append(modExports.packageName().replace('/', '.'));
        if (!modExports.moduleNames().isEmpty()) {
            this.append(" to").append('\n');
            this.indent += 2;
            boolean first = true;
            for (String moduleName : modExports.moduleNames()) {
                if (!first) {
                    this.append(',').append('\n');
                }
                this.append(moduleName);
                first = false;
            }
            this.indent -= 2;
        }
        this.append(";");
        this.append('\n');
        return null;
    }

    @Override
    public Void visitModOpens(Tree.ModOpens modOpens, Void input) {
        this.append("opens ");
        this.append(modOpens.packageName().replace('/', '.'));
        if (!modOpens.moduleNames().isEmpty()) {
            this.append(" to").append('\n');
            this.indent += 2;
            boolean first = true;
            for (String moduleName : modOpens.moduleNames()) {
                if (!first) {
                    this.append(',').append('\n');
                }
                this.append(moduleName);
                first = false;
            }
            this.indent -= 2;
        }
        this.append(";");
        this.append('\n');
        return null;
    }

    @Override
    public Void visitModUses(Tree.ModUses modUses, Void input) {
        this.append("uses ");
        this.append(Joiner.on((char)'.').join(modUses.typeName()));
        this.append(";");
        this.append('\n');
        return null;
    }

    @Override
    public Void visitModProvides(Tree.ModProvides modProvides, Void input) {
        this.append("provides ");
        this.append(Joiner.on((char)'.').join(modProvides.typeName()));
        if (!modProvides.implNames().isEmpty()) {
            this.append(" with").append('\n');
            this.indent += 2;
            boolean first = true;
            for (ImmutableList implName : modProvides.implNames()) {
                if (!first) {
                    this.append(',').append('\n');
                }
                this.append(Joiner.on((char)'.').join((Iterable)implName));
                first = false;
            }
            this.indent -= 2;
        }
        this.append(";");
        this.append('\n');
        return null;
    }
}

