/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.block;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.shaded.dataflow.cfg.block.Block;

public abstract class BlockImpl
implements Block {
    protected final long id = BlockImpl.uniqueID();
    protected static long lastId = 0L;
    protected final Block.BlockType type;
    protected final Set<BlockImpl> predecessors;

    private static long uniqueID() {
        return lastId++;
    }

    public BlockImpl(Block.BlockType type) {
        this.type = type;
        this.predecessors = new HashSet<BlockImpl>();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Block.BlockType getType() {
        return this.type;
    }

    public Set<BlockImpl> getPredecessors() {
        return Collections.unmodifiableSet(this.predecessors);
    }

    public void addPredecessor(BlockImpl pred) {
        this.predecessors.add(pred);
    }

    public void removePredecessor(BlockImpl pred) {
        this.predecessors.remove(pred);
    }
}

