/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import edu.umd.cs.findbugs.formatStringChecker.Formatter;
import edu.umd.cs.findbugs.formatStringChecker.MissingFormatArgumentException;
import java.io.Serializable;

@BugPattern(name="OrphanedFormatString", summary="String literal contains format specifiers, but is not passed to a format method", severity=BugPattern.SeverityLevel.WARNING)
public class OrphanedFormatString
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    private static final Matcher<Tree> LIKELY_MISTAKE_METHOD_CALL = Matchers.toType(ExpressionTree.class, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass("java.lang.StringBuilder"), Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(TypePredicates.isDescendantOf((Supplier & Serializable)s -> s.getSymtab().throwableType)), (Matcher & Serializable)(tree, state) -> {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        return sym instanceof Symbol.MethodSymbol && !((Symbol.MethodSymbol)sym).isVarArgs();
    }}), MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"java.io.PrintStream", "java.io.PrintWriter"}).namedAnyOf(new String[]{"print", "println"}), MethodMatchers.instanceMethod().onExactClass("java.lang.StringBuilder").named("append").withParameters(new String[]{"java.lang.CharSequence", "int", "int"})}));

    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        Object value = tree.getValue();
        if (!(value instanceof String)) {
            return Description.NO_MATCH;
        }
        if (!OrphanedFormatString.missingFormatArgs((String)value)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (LIKELY_MISTAKE_METHOD_CALL.matches(parent, state)) {
            if (parent.getKind() == Tree.Kind.METHOD_INVOCATION && OrphanedFormatString.literalIsFormatMethodArg(tree, (MethodInvocationTree)parent, state)) {
                return Description.NO_MATCH;
            }
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean literalIsFormatMethodArg(LiteralTree tree, MethodInvocationTree methodInvocationTree, VisitorState state) {
        int indexOfParam;
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree);
        if (ASTHelpers.hasAnnotation((Symbol)symbol, FormatMethod.class, (VisitorState)state) && (indexOfParam = OrphanedFormatString.findIndexOfFormatStringParameter(state, symbol)) != -1) {
            java.util.List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
            return args.size() > indexOfParam && args.get(indexOfParam) == tree;
        }
        return false;
    }

    private static int findIndexOfFormatStringParameter(VisitorState state, Symbol.MethodSymbol symbol) {
        int indexOfFirstString = -1;
        List<Symbol.VarSymbol> params = symbol.params();
        for (int i = 0; i < params.size(); ++i) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)params.get(i);
            if (ASTHelpers.hasAnnotation((Symbol)varSymbol, FormatString.class, (VisitorState)state)) {
                return i;
            }
            if (indexOfFirstString != -1 || !ASTHelpers.isSameType((Type)varSymbol.type, (Type)state.getSymtab().stringType, (VisitorState)state)) continue;
            indexOfFirstString = i;
        }
        return indexOfFirstString;
    }

    private static boolean missingFormatArgs(String value) {
        try {
            Formatter.check((String)value, (String[])new String[0]);
        }
        catch (MissingFormatArgumentException e) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

