/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

public class ImmutableListCodec<T>
implements ObjectCodec<ImmutableList<T>> {
    private final ObjectCodec<T> codec;

    ImmutableListCodec(ObjectCodec<T> codec) {
        this.codec = codec;
    }

    @Override
    public Class<ImmutableList<T>> getEncodedClass() {
        return ImmutableList.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableList<T> list, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(list.size());
        for (Object item : list) {
            this.codec.serialize(context, item, codedOut);
        }
    }

    @Override
    public ImmutableList<T> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int length = codedIn.readInt32();
        if (length < 0) {
            throw new SerializationException("Expected non-negative length: " + length);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < length; ++i) {
            builder.add(this.codec.deserialize(context, codedIn));
        }
        return builder.build();
    }
}

