/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.tools.javac.main.Main;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.server.Sjavac;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PooledSjavac
implements Sjavac {
    final Sjavac delegate;
    final ExecutorService pool;

    public PooledSjavac(Sjavac delegate, int poolsize) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.pool = Executors.newFixedThreadPool(poolsize);
    }

    @Override
    public Main.Result compile(String[] args) {
        Log log = Log.get();
        try {
            return this.pool.submit(() -> {
                Log.setLogForCurrentThread(log);
                return this.delegate.compile(args);
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error during compile", e);
        }
    }

    @Override
    public void shutdown() {
        Log.debug("Shutting down PooledSjavac");
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    Log.error("ThreadPool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.delegate.shutdown();
    }
}

