/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="StronglyTypeTime", summary="This primitive integral type is only used to construct time types. It would be clearer to strongly type the field instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class StronglyTypeTime
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> TIME_FACTORY = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.time.Duration").namedAnyOf(new String[]{"ofNanos", "ofMillis", "ofSeconds", "ofMinutes", "ofHours", "ofDays"}).withParameters(new String[]{"long"}), Matchers.staticMethod().onClass("java.time.Instant").namedAnyOf(new String[]{"ofEpochMilli", "ofEpochSecond"}).withParameters(new String[]{"long"}), Matchers.staticMethod().onClass("com.google.protobuf.util.Timestamps").namedAnyOf(new String[]{"fromNanos", "fromMicros", "fromMillis", "fromSeconds"}), Matchers.staticMethod().onClass("com.google.protobuf.util.Durations").namedAnyOf(new String[]{"fromNanos", "fromMicros", "fromMillis", "fromSeconds", "fromMinutes", "fromHours", "fromDays"}), Matchers.staticMethod().onClass("org.joda.time.Duration").namedAnyOf(new String[]{"millis", "standardSeconds", "standardMinutes", "standardHours", "standardDays"}).withParameters(new String[]{"long"}), Matchers.constructor().forClass("org.joda.time.Instant").withParameters(new String[]{"long"}), Matchers.constructor().forClass("org.joda.time.DateTime").withParameters(new String[]{"long"})});
    private static final Pattern TIME_UNIT_REMOVER = Pattern.compile("((_?IN)?_?(NANO|NANOSECOND|NSEC|_NS|MICRO|MSEC|MICROSECOND|MILLI|MILLISECOND|_MS|SEC|SECOND|MINUTE|MIN|HOUR|DAY)S?)?$", 2);

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final Map<Symbol.VarSymbol, TreePath> fields = this.findPathToPotentialFields(state);
        HashMultimap usages = HashMultimap.create();
        new TreePathScanner<Void, Void>((SetMultimap)usages){
            final /* synthetic */ SetMultimap val$usages;
            {
                this.val$usages = setMultimap;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                this.handle(memberSelectTree);
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                this.handle(identifierTree);
                return null;
            }

            private void handle(Tree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (!fields.containsKey(symbol)) {
                    return;
                }
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (!(parent instanceof ExpressionTree) || !TIME_FACTORY.matches((Tree)((ExpressionTree)parent), state)) {
                    fields.remove(symbol);
                    return;
                }
                this.val$usages.put((Object)((Symbol.VarSymbol)symbol), (Object)((ExpressionTree)parent));
            }
        }.scan(tree, null);
        for (Map.Entry<Symbol.VarSymbol, TreePath> entry : fields.entrySet()) {
            state.reportMatch(this.describeMatch(entry.getValue(), usages.get((Object)entry.getKey()), state));
        }
        return Description.NO_MATCH;
    }

    private Description describeMatch(TreePath variableTreePath, Set<ExpressionTree> invocationTrees, VisitorState state) {
        if (invocationTrees.stream().map(ASTHelpers::getSymbol).distinct().count() != 1L) {
            return Description.NO_MATCH;
        }
        VariableTree variableTree = (VariableTree)variableTreePath.getLeaf();
        ExpressionTree factory = invocationTrees.iterator().next();
        String newName = StronglyTypeTime.createNewName(variableTree.getName().toString());
        SuggestedFix.Builder fix = SuggestedFix.builder();
        Type targetType = ASTHelpers.getType((Tree)factory);
        String typeName = SuggestedFixes.qualifyType((VisitorState)state.withPath(variableTreePath), (SuggestedFix.Builder)fix, (TypeMirror)targetType);
        fix.replace((Tree)variableTree, String.format("%s %s %s = %s(%s);", state.getSourceForNode((Tree)variableTree.getModifiers()), typeName, newName, StronglyTypeTime.getMethodSelectOrNewClass(factory, state), state.getSourceForNode((Tree)variableTree.getInitializer())));
        for (ExpressionTree expressionTree : invocationTrees) {
            fix.replace((Tree)expressionTree, newName);
        }
        return this.buildDescription(variableTree).setMessage(String.format("This primitive integral type is only used to construct %s instances. It would be clearer to strongly type the field instead.", targetType.tsym.getSimpleName())).addFix((Fix)fix.build()).build();
    }

    private static String getMethodSelectOrNewClass(ExpressionTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                return state.getSourceForNode((Tree)((MethodInvocationTree)tree).getMethodSelect());
            }
            case NEW_CLASS: {
                return "new " + state.getSourceForNode((Tree)((NewClassTree)tree).getIdentifier());
            }
        }
        throw new AssertionError();
    }

    private static String createNewName(String fieldName) {
        String newName = TIME_UNIT_REMOVER.matcher(fieldName).replaceAll("");
        return newName.isEmpty() ? fieldName : newName;
    }

    private Map<Symbol.VarSymbol, TreePath> findPathToPotentialFields(final VisitorState state) {
        final HashMap<Symbol.VarSymbol, TreePath> fields = new HashMap<Symbol.VarSymbol, TreePath>();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(){

            public Void visitVariable(VariableTree variableTree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
                Type type = state.getTypes().unboxedTypeOrType(symbol.type);
                if (symbol.getKind() == ElementKind.FIELD && symbol.getModifiers().contains((Object)Modifier.PRIVATE) && ASTHelpers.isConsideredFinal((Symbol)symbol) && variableTree.getInitializer() != null && (ASTHelpers.isSameType((Type)type, (Type)state.getSymtab().intType, (VisitorState)state) || ASTHelpers.isSameType((Type)type, (Type)state.getSymtab().longType, (VisitorState)state) || ASTHelpers.isSameType((Type)type, (Type)state.getSymtab().floatType, (VisitorState)state) || ASTHelpers.isSameType((Type)type, (Type)state.getSymtab().doubleType, (VisitorState)state)) && !StronglyTypeTime.this.isSuppressed(variableTree)) {
                    fields.put(symbol, this.getCurrentPath());
                }
                return (Void)super.visitVariable(variableTree, null);
            }
        }.scan((Tree)state.getPath().getCompilationUnit(), null);
        return fields;
    }
}

