/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.DurationGetTemporalUnit;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;

@BugPattern(name="DurationTemporalUnit", summary="Duration APIs only work for DAYS or exact durations.", explanation="Duration APIs only work for TemporalUnits with exact durations or ChronoUnit.DAYS. E.g., Duration.of(1, ChronoUnit.YEARS) is guaranteed to throw a DateTimeException.", severity=BugPattern.SeverityLevel.ERROR)
public final class DurationTemporalUnit
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String DURATION = "java.time.Duration";
    private static final String TEMPORAL_UNIT = "java.time.temporal.TemporalUnit";
    private static final Matcher<ExpressionTree> DURATION_OF_LONG_TEMPORAL_UNIT = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.time.Duration").named("of").withParameters(new String[]{"long", "java.time.temporal.TemporalUnit"}), MethodMatchers.instanceMethod().onExactClass("java.time.Duration").named("minus").withParameters(new String[]{"long", "java.time.temporal.TemporalUnit"}), MethodMatchers.instanceMethod().onExactClass("java.time.Duration").named("plus").withParameters(new String[]{"long", "java.time.temporal.TemporalUnit"})}), Matchers.not((Matcher)Matchers.packageStartsWith((String)"java."))});
    private static final ImmutableSet<ChronoUnit> INVALID_TEMPORAL_UNITS = (ImmutableSet)Arrays.stream(ChronoUnit.values()).filter(c -> c.isDurationEstimated()).filter(c -> !c.equals(ChronoUnit.DAYS)).collect(Sets.toImmutableEnumSet());

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (DURATION_OF_LONG_TEMPORAL_UNIT.matches((Tree)tree, state) && DurationGetTemporalUnit.getInvalidChronoUnit(tree.getArguments().get(1), INVALID_TEMPORAL_UNITS).isPresent()) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

