/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Locale;

final class FormatStringUtils {
    private static final Matcher<ExpressionTree> FORMAT_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"java.io.PrintStream", "java.io.PrintWriter", "java.util.Formatter", "java.io.Console"}).namedAnyOf(new String[]{"format", "printf"}), MethodMatchers.staticMethod().onClass("java.lang.String").named("format"), MethodMatchers.instanceMethod().onExactClass("java.io.Console").withSignature("readPassword(java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onExactClass("java.io.Console").withSignature("readLine(java.lang.String,java.lang.Object...)")});

    static ImmutableList<ExpressionTree> formatMethodArguments(MethodInvocationTree tree, VisitorState state) {
        if (!FORMAT_METHOD.matches((Tree)tree, state)) {
            return ImmutableList.of();
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (sym == null) {
            return ImmutableList.of();
        }
        ImmutableList args = ImmutableList.copyOf(tree.getArguments());
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)((Tree)args.get(0))), (Type)state.getTypeFromString(Locale.class.getName()), (VisitorState)state)) {
            args = args.subList(1, args.size());
        }
        return args;
    }

    private FormatStringUtils() {
    }
}

