/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;

@BugPattern(name="UnnecessaryBoxedAssignment", summary="This expression can be implicitly boxed.", explanation="It is unnecessary for this assignment or return expression to be boxed explicitly.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class UnnecessaryBoxedAssignment
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> VALUE_OF_MATCHER = MethodMatchers.staticMethod().onClass(UnnecessaryBoxedAssignment::isBoxableType).named("valueOf");

    public Description matchReturn(ReturnTree tree, VisitorState state) {
        return this.matchCommon(tree.getExpression(), state);
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        return this.matchCommon(tree.getExpression(), state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.matchCommon(tree.getInitializer(), state);
    }

    private Description matchCommon(ExpressionTree expression, VisitorState state) {
        if (expression == null || !VALUE_OF_MATCHER.matches((Tree)expression, state)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expression;
        if (methodInvocationTree.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = methodInvocationTree.getArguments().get(0);
        Type argType = ASTHelpers.getType((Tree)arg);
        if (ASTHelpers.isSameType((Type)argType, (Type)state.getSymtab().stringType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType((Type)state.getTypes().unboxedTypeOrType(argType), (Type)state.getTypes().unboxedType(ASTHelpers.getType((Tree)expression)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(expression, (Fix)SuggestedFix.replace((Tree)expression, (String)state.getSourceForNode((Tree)arg)));
    }

    private static boolean isBoxableType(Type type, VisitorState state) {
        Type unboxedType = state.getTypes().unboxedType(type);
        return unboxedType != null && unboxedType.getTag() != TypeTag.NONE;
    }
}

