/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import javax.lang.model.element.Modifier;

@BugPattern(name="TransientMisuse", summary="Static fields are implicitly transient, so the explicit modifier is unnecessary", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.WARNING)
public class TransientMisuse
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getModifiers().getFlags().containsAll((Collection<?>)ImmutableList.of((Object)((Object)Modifier.STATIC), (Object)((Object)Modifier.TRANSIENT)))) {
            return this.describeMatch(tree, SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.TRANSIENT}));
        }
        return Description.NO_MATCH;
    }
}

