/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.unsafe;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public class UnsafeProvider {
    private static final Unsafe UNSAFE = UnsafeProvider.getUnsafe();

    public static Unsafe getInstance() {
        return UNSAFE;
    }

    private static Unsafe getUnsafe() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> unsafeClass = Unsafe.class;
                    for (Field f : unsafeClass.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object fieldValue = f.get(null);
                        if (!unsafeClass.isInstance(fieldValue)) continue;
                        return (Unsafe)unsafeClass.cast(fieldValue);
                    }
                    throw new AssertionError((Object)"Failed to find sun.misc.Unsafe instance");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new AssertionError("Unable to get sun.misc.Unsafe", pae);
        }
    }
}

