/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import jakarta.servlet.http.HttpSession;
import org.basex.http.HTTPConnection;
import org.basex.query.QueryContext;
import org.basex.util.Performance;

final class RestXqSingleton {
    private static final Object MUTEX = new Object();
    private final String id;
    private final QueryContext qc;
    private final HttpSession session;

    RestXqSingleton(HTTPConnection conn, String id, QueryContext qc) {
        this.qc = qc;
        this.id = id;
        this.session = conn.request.getSession();
        this.queue();
        this.register();
    }

    private void queue() {
        QueryContext oldQc = this.qc();
        if (oldQc != null) {
            oldQc.stop();
            do {
                Performance.sleep((long)10L);
            } while (this.qc() == oldQc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register() {
        Object object = MUTEX;
        synchronized (object) {
            this.session.setAttribute(this.id, (Object)this.qc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister() {
        Object object = MUTEX;
        synchronized (object) {
            if (this.qc == this.qc()) {
                this.session.removeAttribute(this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryContext qc() {
        Object object = MUTEX;
        synchronized (object) {
            QueryContext qctx;
            Object object2 = HTTPConnection.getAttribute(this.session, this.id);
            return object2 instanceof QueryContext ? (qctx = (QueryContext)object2) : null;
        }
    }
}

