/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Strings;

public final class RestXqPerm
implements Comparable<RestXqPerm> {
    private final String path;
    final QNm var;

    RestXqPerm(String path, QNm var) {
        this.path = ("/" + path + "/").replaceAll("^/+|/+$", "/");
        this.var = var;
    }

    static XQMap map(RestXqFunction func, HTTPConnection conn) throws QueryException {
        return new MapBuilder().put("allow", StrSeq.get((byte[][])((byte[][])func.allows.toArray()))).put("path", conn.path()).put("method", conn.method).put("headers", (Value)conn.requestCtx.headers()).put("parameters", (Value)conn.requestCtx.queryValues()).put("authorization", conn.request.getHeader("Authorization")).map();
    }

    boolean matches(HTTPConnection conn) {
        String p = conn.path();
        return ((String)(Strings.endsWith((String)p, (char)'/') ? p : p + "/")).startsWith(this.path);
    }

    @Override
    public int compareTo(RestXqPerm rxp) {
        return this.path.length() - rxp.path.length();
    }
}

