/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.concurrent.ConcurrentHashMap;
import org.basex.util.list.TokenList;

public final class SessionListener
implements HttpSessionListener {
    private static final ConcurrentHashMap<String, HttpSession> SESSIONS = new ConcurrentHashMap();

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession sess = event.getSession();
        SESSIONS.put(sess.getId(), sess);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        SESSIONS.remove(event.getSession().getId());
    }

    public static TokenList ids() {
        TokenList ids = new TokenList((long)SESSIONS.size());
        for (String key : SESSIONS.keySet()) {
            ids.add(key);
        }
        return ids;
    }

    public static HttpSession get(String id) {
        return SESSIONS.get(id);
    }
}

