/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.io.IOException;
import org.basex.core.Stores;
import org.basex.io.in.DataInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.FType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public class MapType
extends FType {
    private Type keyType;
    private SeqType valueType;
    private boolean isFinal;

    MapType(Type keyType, SeqType valueType) {
        this(keyType, valueType, true);
    }

    MapType(Type keyType, SeqType valueType, boolean isFinal) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.isFinal = isFinal;
    }

    public static MapType get(Type keyType, SeqType valueType) {
        MapType mt = valueType.mapType(keyType);
        if (!mt.isFinal) {
            throw Util.notExpected();
        }
        return mt;
    }

    public void finalizeTypes(Type kt, SeqType vt) {
        if (this.isFinal) {
            throw Util.notExpected();
        }
        this.keyType = kt;
        this.valueType = vt;
        this.isFinal = true;
    }

    public Type keyType() {
        return this.keyType;
    }

    public SeqType valueType() {
        return this.valueType;
    }

    @Override
    public final XQMap cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
        XQMap map;
        if (item instanceof XQMap && (map = (XQMap)item).instanceOf(this, false)) {
            return map;
        }
        throw QueryError.typeError(item, this, info);
    }

    @Override
    public final XQMap read(DataInput in, QueryContext qc) throws IOException, QueryException {
        int size = in.readNum();
        MapBuilder mb = new MapBuilder(size);
        while (--size >= 0) {
            mb.put((Item)Stores.read(in, qc), Stores.read(in, qc));
        }
        return mb.map();
    }

    @Override
    public boolean eq(Type type) {
        if (this == type) {
            return true;
        }
        if (type.getClass() != MapType.class) {
            return false;
        }
        MapType mt = (MapType)type;
        return this.keyType.eq(mt.keyType) && this.valueType.eq(mt.valueType);
    }

    @Override
    public boolean instanceOf(Type type) {
        ChoiceItemType cit;
        if (this == type || type.oneOf(Types.RECORD, Types.MAP, Types.FUNCTION, AtomType.ITEM)) {
            return true;
        }
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            return this != Types.MAP && this.valueType.instanceOf(mt.valueType) && this.keyType.instanceOf(mt.keyType);
        }
        if (type instanceof FuncType) {
            FuncType ft = (FuncType)type;
            return this.funcType().declType.instanceOf(ft.declType) && ft.argTypes.length == 1 && ft.argTypes[0].instanceOf(Types.ANY_ATOMIC_TYPE_O);
        }
        return type instanceof ChoiceItemType && (cit = (ChoiceItemType)type).hasInstance(this);
    }

    @Override
    public Type union(Type type) {
        if (type instanceof ChoiceItemType) {
            return type.union(this);
        }
        if (type == Types.RECORD) {
            return Types.MAP;
        }
        if (this.instanceOf(type)) {
            return type;
        }
        if (type.instanceOf(this)) {
            return this;
        }
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            return this.union(mt.keyType, mt.valueType);
        }
        return type instanceof ArrayType ? Types.FUNCTION : (type instanceof FuncType ? type.union(this) : AtomType.ITEM);
    }

    public MapType union(Type kt, SeqType vt) {
        return this.keyType.eq(kt) && this.valueType.eq(vt) ? this : MapType.get(this.keyType.union(kt), this.valueType.union(vt));
    }

    @Override
    public Type intersect(Type type) {
        if (type instanceof ChoiceItemType) {
            return type.intersect(this);
        }
        if (type == Types.RECORD) {
            return Types.RECORD;
        }
        if (this.instanceOf(type)) {
            return this;
        }
        if (type.instanceOf(this)) {
            return type;
        }
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            Type kt = this.keyType.intersect(mt.keyType);
            SeqType vt = this.valueType.intersect(mt.valueType);
            if (kt != null && kt.atomic() != null && vt != null) {
                return MapType.get(kt, vt);
            }
        }
        return null;
    }

    @Override
    public Type.ID id() {
        return Type.ID.MAP;
    }

    @Override
    public final FuncType funcType() {
        return FuncType.get(this.valueType.union(Occ.ZERO), this.keyType.seqType());
    }

    @Override
    public final AtomType atomic() {
        return null;
    }

    @Override
    public String toString() {
        Object[] objectArray;
        if (this == Types.MAP) {
            objectArray = WILDCARD;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this.keyType;
            objectArray = objectArray2;
            objectArray2[1] = this.valueType;
        }
        Object[] param = objectArray;
        return new QueryString().token("map").params(param).toString();
    }
}

