/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.io.IOException;
import org.basex.core.Stores;
import org.basex.io.in.DataInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.FType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;

public final class ArrayType
extends FType {
    private final SeqType valueType;

    ArrayType(SeqType valueType) {
        this.valueType = valueType;
    }

    public static ArrayType get(SeqType valueType) {
        return valueType.arrayType();
    }

    public SeqType valueType() {
        return this.valueType;
    }

    @Override
    public XQArray cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
        XQArray array;
        if (item instanceof XQArray && (array = (XQArray)item).instanceOf(this, false)) {
            return array;
        }
        throw QueryError.typeError(item, this, info);
    }

    @Override
    public XQArray read(DataInput in, QueryContext qc) throws IOException, QueryException {
        int size = in.readNum();
        ArrayBuilder ab = new ArrayBuilder(qc, size);
        while (--size >= 0) {
            ab.add(Stores.read(in, qc));
        }
        return ab.array(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean eq(Type type) {
        if (this == type) return true;
        if (!(type instanceof ArrayType)) return false;
        ArrayType at = (ArrayType)type;
        if (!this.valueType.eq(at.valueType)) return false;
        return true;
    }

    @Override
    public boolean instanceOf(Type type) {
        ChoiceItemType cit;
        if (this == type || type.oneOf(Types.ARRAY, Types.FUNCTION, AtomType.ITEM)) {
            return true;
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            return this != Types.ARRAY && this.valueType.instanceOf(at.valueType);
        }
        if (type instanceof FuncType) {
            FuncType ft = (FuncType)type;
            return this.valueType.instanceOf(ft.declType) && ft.argTypes.length == 1 && ft.argTypes[0].instanceOf(Types.INTEGER_O);
        }
        return type instanceof ChoiceItemType && (cit = (ChoiceItemType)type).hasInstance(this);
    }

    @Override
    public Type union(Type type) {
        Type type2;
        if (type instanceof ChoiceItemType) {
            type2 = type.union(this);
        } else if (this.instanceOf(type)) {
            type2 = type;
        } else if (type.instanceOf(this)) {
            type2 = this;
        } else if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            type2 = this.union(at.valueType);
        } else {
            type2 = type instanceof MapType ? Types.FUNCTION : (type instanceof FuncType ? type.union(this) : AtomType.ITEM);
        }
        return type2;
    }

    public ArrayType union(SeqType vt) {
        return this.valueType.eq(vt) ? this : ArrayType.get(this.valueType.union(vt));
    }

    @Override
    public ArrayType intersect(Type type) {
        if (type instanceof ChoiceItemType) {
            return (ArrayType)type.intersect(this);
        }
        if (this.instanceOf(type)) {
            return this;
        }
        if (type.instanceOf(this)) {
            return (ArrayType)type;
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            SeqType mt = this.valueType.intersect(at.valueType);
            if (mt != null) {
                return ArrayType.get(mt);
            }
        }
        return null;
    }

    @Override
    public FuncType funcType() {
        return FuncType.get(this.valueType, Types.INTEGER_O);
    }

    @Override
    public AtomType atomic() {
        return this.valueType.type.atomic();
    }

    @Override
    public Type.ID id() {
        return Type.ID.ARRAY;
    }

    @Override
    public String toString() {
        Object[] objectArray;
        if (this == Types.ARRAY) {
            objectArray = WILDCARD;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.valueType;
        }
        Object[] param = objectArray;
        return new QueryString().token("array").params(param).toString();
    }
}

