/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Arrays;
import java.util.ListIterator;
import org.basex.core.jobs.Job;
import org.basex.query.QueryContext;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicIter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.tree.BigSeq;
import org.basex.query.value.seq.tree.TreeSeq;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Util;

public final class SmallSeq
extends TreeSeq {
    final Item[] items;

    SmallSeq(Item[] items, Type type) {
        super(items.length, type);
        this.items = items;
        assert (items.length >= 2 && items.length <= 7);
    }

    @Override
    TreeSeq prepend(SmallSeq seq) {
        Type tp = this.type.union(seq.type);
        Item[] tmp = seq.items;
        int tl = tmp.length;
        int il = this.items.length;
        int n = tl + il;
        if (Math.min(tl, il) >= 4) {
            return new BigSeq(tmp, this.items, tp);
        }
        Item[] out = new Item[n];
        Array.copy(tmp, tl, out);
        Array.copyFromStart(this.items, il, out, tl);
        if (n <= 7) {
            return new SmallSeq(out, tp);
        }
        int mid = n / 2;
        return new BigSeq(SmallSeq.slice(out, 0, mid), SmallSeq.slice(out, mid, n), tp);
    }

    @Override
    public Item itemAt(long index) {
        return this.items[(int)index];
    }

    @Override
    public TreeSeq reverse(Job job) {
        int il = this.items.length;
        Item[] tmp = new Item[il];
        for (int i = 0; i < il; ++i) {
            tmp[i] = this.items[il - 1 - i];
        }
        return new SmallSeq(tmp, this.type);
    }

    @Override
    public Value insertValue(long pos, Value value, Job job) {
        if (value.size() > 1L) {
            return this.copyInsert(pos, value, job);
        }
        Item item = (Item)value;
        Type tp = this.type.union(item.type);
        int p = (int)pos;
        int il = this.items.length;
        Item[] out = new Item[il + 1];
        Array.copy(this.items, p, out);
        out[p] = item;
        Array.copy(this.items, p, il - p, out, p + 1);
        return il < 7 ? new SmallSeq(out, tp) : new BigSeq(SmallSeq.slice(out, 0, 4), SmallSeq.slice(out, 4, il + 1), tp);
    }

    @Override
    public Value removeItem(long pos, Job job) {
        job.checkStop();
        int il = this.items.length;
        int p = (int)pos;
        if (il == 2) {
            return this.items[p == 0 ? 1 : 0];
        }
        Item[] out = new Item[il - 1];
        Array.copy(this.items, p, out);
        Array.copy(this.items, p + 1, il - 1 - p, out, p);
        return new SmallSeq(out, this.type);
    }

    @Override
    protected Seq subSeq(long pos, long length, Job job) {
        job.checkStop();
        int p = (int)pos;
        int l = (int)length;
        return new SmallSeq(SmallSeq.slice(this.items, p, p + l), this.type);
    }

    @Override
    TreeSeq append(TreeSeq other) {
        return other.prepend(this);
    }

    @Override
    public ListIterator<Item> iterator(final long start) {
        return new ListIterator<Item>(){
            private int index;
            {
                this.index = (int)start;
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public boolean hasNext() {
                return this.index < SmallSeq.this.items.length;
            }

            @Override
            public Item next() {
                return SmallSeq.this.items[this.index++];
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Item previous() {
                return SmallSeq.this.items[--this.index];
            }

            @Override
            public void set(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void add(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(this.size){

            @Override
            public Item get(long i) {
                return SmallSeq.this.items[(int)i];
            }

            @Override
            public boolean valueIter() {
                return true;
            }

            @Override
            public SmallSeq value(QueryContext qc, Expr expr) {
                return SmallSeq.this;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof SmallSeq) {
            SmallSeq ss = (SmallSeq)obj;
            if (!Arrays.equals(this.items, ss.items)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }
}

