/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.ItemSeq;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;

final class TrieKeys
implements Iterable<Item> {
    private boolean copy;
    private final Item[] keys;
    private final int size;

    TrieKeys(Item ... keys) {
        this(keys, keys.length);
    }

    TrieKeys(Item[] keys, int size) {
        this.keys = keys;
        this.size = size;
    }

    TrieKeys add(Item key) {
        Item[] ks;
        int sz = this.size;
        if (sz == this.keys.length) {
            ks = Array.copy(this.keys, new Item[Array.newCapacity(sz)]);
        } else if (this.copy) {
            ks = (Item[])this.keys.clone();
        } else {
            ks = this.keys;
            this.copy = true;
        }
        ks[sz] = key;
        return new TrieKeys(ks, sz + 1);
    }

    Value keys() {
        return ItemSeq.get(this.keys, this.size, null);
    }

    Item keyAt(int index) {
        return this.keys[index];
    }

    TrieKeys remove(TrieKeys list) {
        IdentityHashMap<Item, Integer> map = new IdentityHashMap<Item, Integer>();
        for (Item key : list) {
            map.merge(key, 1, Integer::sum);
        }
        int sz = this.size - list.size;
        ItemList tmp = new ItemList(sz);
        for (Item key : this) {
            if (!map.isEmpty() && map.containsKey(key)) {
                int occ = (Integer)map.get(key);
                if (occ == 1) {
                    map.remove(key);
                    continue;
                }
                map.put(key, occ - 1);
                continue;
            }
            tmp.add(key);
        }
        return new TrieKeys((Item[])tmp.finish(), sz);
    }

    @Override
    public Iterator<Item> iterator() {
        return new ArrayIterator<Item>(this.keys, this.size);
    }

    public String toString() {
        return Arrays.toString(this.keys);
    }
}

