/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.basex.io.IOFile;
import org.basex.io.in.ArrayInput;
import org.basex.util.list.ByteList;

final class RepoArchive {
    private final byte[] data;

    RepoArchive(byte[] data) {
        this.data = data;
    }

    byte[] read(String path) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new ArrayInput(this.data));){
            byte[] cont = RepoArchive.getEntry(in, path);
            if (cont == null) {
                throw new FileNotFoundException(path);
            }
            byte[] byArray = cont;
            return byArray;
        }
    }

    void unzip(IOFile target) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new ArrayInput(this.data));){
            ZipEntry ze;
            while ((ze = in.getNextEntry()) != null) {
                IOFile trg = new IOFile(target, ze.getName());
                if (ze.isDirectory()) {
                    trg.md();
                    continue;
                }
                trg.parent().md();
                trg.write(in);
            }
        }
    }

    private static byte[] getEntry(ZipInputStream in, String entry) throws IOException {
        ZipEntry ze;
        while ((ze = in.getNextEntry()) != null) {
            int c;
            if (!entry.equals(ze.getName())) continue;
            int s = (int)ze.getSize();
            if (s >= 0) {
                int c2;
                byte[] data = new byte[s];
                int o = 0;
                while (s - o != 0 && (c2 = in.read(data, o, s - o)) != -1) {
                    o += c2;
                }
                return data;
            }
            byte[] data = new byte[4096];
            ByteList bl = new ByteList();
            while ((c = in.read(data)) != -1) {
                bl.add(data, 0, c);
            }
            return bl.finish();
        }
        return null;
    }
}

