/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.validate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.validate.ErrorInfo;
import org.basex.query.func.validate.Validation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.Type;
import org.basex.util.Checks;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.TokenList;
import org.xml.sax.SAXException;

abstract class ValidateFn
extends StandardFunc {
    static final ConcurrentHashMap<String, Schema> MAP = new ConcurrentHashMap();
    private static final QNm Q_REPORT = new QNm("report");
    private static final QNm Q_MESSAGE = new QNm("message");
    private static final QNm Q_STATUS = new QNm("status");
    private static final QNm Q_LINE = new QNm("line");
    private static final QNm Q_COLUMN = new QNm("column");
    private static final QNm Q_LEVEL = new QNm("level");
    private static final QNm Q_URL = new QNm("url");
    private static final String VALID = "valid";
    private static final String INVALID = "invalid";

    ValidateFn() {
    }

    protected final Empty check(QueryContext qc) throws QueryException {
        ArrayList<ErrorInfo> errors = this.errors(qc);
        if (errors.isEmpty()) {
            return Empty.VALUE;
        }
        throw QueryError.VALIDATE_ERROR_X.get(this.info, errors.get(0).toString());
    }

    protected final Value info(QueryContext qc) throws QueryException {
        ArrayList<ErrorInfo> errors = this.errors(qc);
        TokenList tl = new TokenList(errors.size());
        for (ErrorInfo error : errors) {
            tl.add(error.toString());
        }
        return StrSeq.get(tl);
    }

    protected final FNode report(QueryContext qc) throws QueryException {
        ArrayList<ErrorInfo> errors = this.errors(qc);
        Checks<ErrorInfo> warnings = ei -> ei.level == ErrorInfo.Level.WARNING;
        FBuilder report = FElem.build(Q_REPORT);
        report.add(FElem.build(Q_STATUS).add(warnings.all(errors) ? VALID : INVALID));
        for (ErrorInfo ei2 : errors) {
            FBuilder error = FElem.build(Q_MESSAGE).add(Q_LEVEL, (Object)ei2.level);
            if (ei2.line != Integer.MIN_VALUE) {
                error.add(Q_LINE, ei2.line);
            }
            if (ei2.column != Integer.MIN_VALUE) {
                error.add(Q_COLUMN, ei2.column);
            }
            report.add(error.add(Q_URL, ei2.url).add(ei2.message));
        }
        return report.finish();
    }

    public abstract ArrayList<ErrorInfo> errors(QueryContext var1) throws QueryException;

    protected final ArrayList<ErrorInfo> validate(Validation v) throws QueryException {
        try {
            v.validate();
        }
        catch (SAXException ex) {
            Util.rootException(ex);
            v.add(ex, ErrorInfo.Level.FATAL);
        }
        catch (IOException | Error | ParserConfigurationException ex) {
            throw QueryError.VALIDATE_START_X.get(this.info, ex);
        }
        finally {
            v.finish();
        }
        return v.getErrors();
    }

    protected final IO read(Item item, SerializerOptions sopts) throws QueryException, IOException {
        if (item instanceof ANode) {
            ANode node = (ANode)item;
            IOContent io = new IOContent(item.serialize(sopts).finish());
            io.name(Token.string(node.baseURI()));
            return io;
        }
        Type type = item.type;
        if (type.isStringOrUntyped()) {
            IO io = this.toIO(this.toString(item), true);
            if (sopts != null) {
                io = new IOContent(new DBNode(io).serialize(sopts).finish());
                io.name(io.path());
            }
            return io;
        }
        throw QueryError.STRNOD_X_X.get(this.info, type, item);
    }
}

