/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.HofArgs;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.map.ValueMerger;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.EnumType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.Checks;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.options.Options;
import org.basex.util.options.ValueOption;

public class MapMerge
extends StandardFunc {
    ValueMerger vm;

    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        MapBuilder mb;
        Iter maps = this.arg(0).iter(qc);
        MergeOptions options = this.toOptions(this.arg(1), new MergeOptions(), qc);
        ValueMerger merger = this.merger(options, qc, Duplicates.USE_FIRST);
        Item first = qc.next(maps);
        if (first == null) {
            return XQMap.empty();
        }
        XQMap mp = this.toMap(first);
        Item current = qc.next(maps);
        if (current == null) {
            return mp;
        }
        Item next = qc.next(maps);
        MapBuilder mapBuilder = mb = next == null ? null : new MapBuilder(this.arg(0).size());
        if (mb != null) {
            mp.forEach(mb::put);
        }
        while (current != null) {
            XQMap map = this.toMap(current);
            for (Item key : map.keys()) {
                Value old;
                Value val = merger.merge(key, old = mb != null ? mb.get(key) : mp.getOrNull(key), map.get(key));
                if (val == null) continue;
                if (mb != null) {
                    mb.put(key, val);
                    continue;
                }
                mp = mp.put(key, val);
            }
            current = next;
            next = current != null ? qc.next(maps) : null;
        }
        return mb != null ? mb.map(this) : mp;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        this.prepareMerge(1, Duplicates.USE_FIRST, cc);
        if (this.arg((int)0).seqType().type instanceof MapType) {
            Expr[] args;
            SeqType st;
            if (this.arg(0) instanceof List && ((Checks<Expr>)arg -> arg == XQMap.empty()).any((Expr[])this.arg(0).args())) {
                ExprList list = new ExprList();
                for (Expr arg2 : this.arg(0).args()) {
                    if (arg2 == XQMap.empty()) continue;
                    list.add(arg2);
                }
                this.arg(0, arg -> List.get(cc, this.info, (Expr[])list.finish()));
            }
            if ((st = this.arg(0).seqType()).one()) {
                return this.arg(0);
            }
            if (!this.defined(1) && this.arg(0) instanceof List && this.arg(0).args().length == 2 && Function._MAP_ENTRY.is((args = this.arg(0).args())[0]) && args[1].seqType().instanceOf(Types.MAP_O)) {
                return cc.function(Function._MAP_PUT, this.info, args[1], args[0].arg(0), args[0].arg(1));
            }
            MapType mt = (MapType)st.type;
            this.assignType(mt.keyType(), mt.valueType());
        }
        return this;
    }

    final void prepareMerge(int arg, Duplicates dflt, CompileContext cc) throws QueryException {
        if (this.arg(arg) instanceof Value) {
            MergeOptions options = new MergeOptions();
            if (this.defined(arg)) {
                options = this.toOptions(this.arg(arg), options, cc.qc);
            }
            this.vm = this.merger(options, cc.qc, dflt);
        }
    }

    final ValueMerger merger(MergeOptions options, QueryContext qc, Duplicates dflt) throws QueryException {
        if (this.vm != null) {
            return this.vm;
        }
        Value duplicates = options.get(MergeOptions.DUPLICATES);
        if (duplicates instanceof FItem) {
            return new Invoke(this.toFunction(duplicates, 2, qc), qc);
        }
        String string = duplicates.isEmpty() ? dflt.toString() : this.toString(duplicates, qc);
        Duplicates value = Enums.get(Duplicates.class, string);
        if (value == null) {
            throw QueryError.typeError(duplicates, EnumType.get(Duplicates.values()), this.info);
        }
        return switch (value) {
            case Duplicates.REJECT -> new Reject();
            case Duplicates.COMBINE -> new Combine(qc);
            case Duplicates.USE_FIRST -> new UseFirst();
            default -> new UseLast();
        };
    }

    final void assignType(Type kt, SeqType vt) {
        this.exprType.assign(MapType.get(kt != null ? kt : AtomType.ANY_ATOMIC_TYPE, this.vm != null ? this.vm.type(vt) : Types.ITEM_ZM));
    }

    @Override
    public int hofOffsets() {
        return this.defined(1) ? Integer.MAX_VALUE : 0;
    }

    public static final class MergeOptions
    extends Options {
        public static final ValueOption DUPLICATES = new ValueOption("duplicates", Types.ITEM_ZM);
    }

    public static enum Duplicates {
        REJECT,
        USE_FIRST,
        USE_LAST,
        USE_ANY,
        COMBINE;


        public String toString() {
            return Enums.string(this);
        }
    }

    final class Invoke
    extends ValueMerger {
        private final FItem function;
        private final QueryContext qc;
        private final HofArgs args;

        Invoke(FItem function, QueryContext qc) {
            this.function = function;
            this.qc = qc;
            this.args = new HofArgs(2);
        }

        @Override
        Value get(Item key, Value old, Value value) throws QueryException {
            return this.function.invoke(this.qc, MapMerge.this.info, this.args.set(0, old).set(1, value).get());
        }

        @Override
        SeqType type(SeqType st) {
            return st.union(this.function.funcType().declType);
        }
    }

    final class Reject
    extends ValueMerger {
        Reject() {
        }

        @Override
        Value get(Item key, Value old, Value value) throws QueryException {
            throw QueryError.MERGE_DUPLICATE_X.get(MapMerge.this.info, key);
        }
    }

    static final class Combine
    extends ValueMerger {
        private final QueryContext qc;

        Combine(QueryContext qc) {
            this.qc = qc;
        }

        @Override
        Value get(Item key, Value old, Value value) {
            return old.append(value, this.qc);
        }

        @Override
        SeqType type(SeqType st) {
            return st.union(st.occ.add(st.occ));
        }
    }

    static final class UseFirst
    extends ValueMerger {
        UseFirst() {
        }

        @Override
        Value get(Item key, Value old, Value value) {
            return null;
        }
    }

    static final class UseLast
    extends ValueMerger {
        UseLast() {
        }

        @Override
        Value get(Item key, Value old, Value value) {
            return value;
        }
    }
}

